% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn.R
\name{knn}
\alias{knn}
\title{k Nearest Neighbour indices and distances}
\usage{
knn(dist, k, self_loops = FALSE)
}
\arguments{
\item{dist}{A numeric matrix, data frame or "\code{dist}" object.}

\item{k}{The maximum number of nearest neighbours to search.}

\item{self_loops}{\code{TRUE} if samples with the same index or name are allowed to be neighbours.}
}
\value{
A list containing two matrices \code{indices} and \code{distances}
}
\description{
\code{knn} returns the indices and distances of the \emph{k} nearest neighbours of each sample.
}
\examples{
## Calculate the kNN distances within a set of samples
x <- matrix(rnorm(50*10, mean=0, sd=1), ncol=10)
dist <- dist(x)
knnd <- knn(dist, 10)
plot(density(knnd$distances))

## Calculate the kNN distances between two sets of samples
library(dynutils)
y <- matrix(rnorm(100*10, mean=1, sd=2), ncol=10)
dist <- calculate_distance(x, y, "euclidean")
knnd <- knn(dist, 10)
plot(density(knnd$distances))
}
