% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCEM.R
\name{SCEM}
\alias{SCEM}
\title{Splitting-Coalescence-Estimation Method (SCEM) for archaeological time series.}
\usage{
SCEM(paths, bandwidth)
}
\arguments{
\item{paths}{A list of data frames, where each frame contains the data for one individual. There
should be two columns with names 'distance' and 'oxygen'.}

\item{bandwidth}{Denotes the order of the bandwidth that should be used in the splitting-coalescence
(SC) clustering algorithm. A value k will mean that the bandwidth used in the algorithm is n^k.}
}
\value{
A list containing the following components:

\item{results}{A data frame that has the individual information (ID, species, number of observations in the time series), cluster assignment, estimated period, delay and the birth seasonality estimate for every individual.}
\item{groups}{The groups formed by the clustering algorithm}
}
\description{
This function performs the clustering algorithm SCEM on the bivariate time series data –
where one series is the distance from the cementum-enamel junction, and the other series is the value of
the oxygen-18 isotope at that distance. It returns the class assignments and birth seasonality estimates
for all the individuals.

The SCEM assumes that the oxygen isotope values \eqn{(z(t))} can be expressed as a function of \eqn{x(t)},
the natural logarithm of the distance from the CEJ for each of the incremental samples, scaled down by
the period (\eqn{X}, the length of the tooth crown). In other words,

\loadmathjax
\mjdeqn{z(t) = f(x(t)/X) + e(t)}{ASCII representation}

where the form of \eqn{f} is unknown and \eqn{e(t)} is an error process.
Also, following our definition, it assumes that the value of \eqn{x(t)/X} that maximizes \eqn{z(t)} is the estimated birth seasonality.

Birth seasonality is estimated using the combined data from all individuals in a single cluster,
but birth seasonality estimates for individuals in a cluster are based on individual estimates of the length of the tooth crown (\mjeqn{X_{k}}{ASCII representation}).

For a detailed description of the algorithm, please see Chazin et al. 2019, Supplemental Materials 1.
}
\examples{
\dontrun{
armenia_split = split(armenia,f = armenia$ID)
results = SCEM(armenia_split,bandwidth = -0.33)
}
}
\references{
Chazin, Hannah, Soudeep Deb, Joshua Falk, and Arun Srinivasan. 2019. “New Statistical Approaches to Intra-Individual Isotopic Analysis and Modeling Birth Seasonality in Studies of Herd Animals.” Archaeometry 61 (2): 478–93.
}
