% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstTrend.R
\name{EstTrend}
\alias{EstTrend}
\title{Estimates the trend function for a time series.}
\usage{
EstTrend(y, time, bandwidth)
}
\arguments{
\item{y}{A vector of time series observations.}

\item{time}{A vector of time points where the value of the trend needs to be estimated.}

\item{bandwidth}{Denotes the order of the bandwidth that should be used in the estimation process.
bandwidth = k will mean that the bandwidth is n^k.}
}
\value{
A vector of estimated values for the trend function at the given time-points.
}
\description{
The trend function for each individual time series is estimated non-parametrically
by the local linear estimate (as discussed in Fan and Gijbels (1996)). Detailed description can
be found in Chazin et al. 2019, Supplemental Materials 1.
}
\examples{
 armenia_split = split(armenia,f = armenia$ID)
 band = -0.33
 z = armenia_split[[1]]$oxygen
 n = length(z)
 ndx = (1:n)/n
 EstTrend(z,ndx,band)
}
