% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampler.R
\name{sampler}
\alias{sampler}
\title{top level sampler function}
\usage{
sampler(
  edges,
  sbmmod,
  nSteps = 1000,
  algorithm = "rj",
  sigma = 0.5,
  statusfreq,
  currsbm,
  ...
)
}
\arguments{
\item{edges}{an \code{\link{edges}} object}

\item{sbmmod}{an \code{\link{sbmmod}} model}

\item{nSteps}{number of steps to run sampler}

\item{algorithm}{choice of algorithm options are: \code{"conjugate", "gibbs", "dp", "rj"}}

\item{sigma}{random walk parameter for \code{theta}}

\item{statusfreq}{print the elapsed number of iterations every \code{statusfreq} iterations}

\item{currsbm}{initial state for \code{sbm} object (optional - one is drawn from \code{sbmmod} if not supplied)}

\item{...}{additional parameters to pass to step}
}
\value{
\code{postz} traces for block assignments \code{z}

\code{postt} traces for \code{theta}

\code{postk} traces for number of blocks \code{kappa}

\code{postn} traces for number of occupied blocks

\code{nsteps} number of iterations of chain

\code{algorithm} choice
}
\description{
top level sampler function
}
\examples{
## see vignette("Weibull-edges")
}
