% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc.QDM.R
\name{QDM}
\alias{QDM}
\title{QDM (Quantile delta mapping method)}
\description{
Perform a bias correction.
}
\details{
Mix of delta and quantile method
}
\examples{
## Three bivariate random variables (rnorm and rexp are inverted between ref
## and bias)
XY = SBCK::dataset_gaussian_exp_2d(2000)
X0 = XY$X0 ## Biased in calibration period
Y0 = XY$Y0 ## Reference in calibration period
X1 = XY$X1 ## Biased in projection period

## Bias correction
## Step 1 : construction of the class QDM
qdm = SBCK::QDM$new() 
## Step 2 : Fit the bias correction model
qdm$fit( Y0 , X0 , X1 )
## Step 3 : perform the bias correction, Z is a list containing
## corrections
Z = qdm$predict(X1,X0) 
Z$Z0 ## Correction in calibration period
Z$Z1 ## Correction in projection period

}
\references{
Cannon, A. J., Sobie, S. R., and Murdock, T. Q.: Bias correction
            of simulated precipitation by quantile mapping: how well do
            methods preserve relative changes in quantiles and extremes?, J.
            Climate, 28, 6938–6959,
            https://doi.org/10.1175/JCLI-D-14- 00754.1, 2015.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{QDM$new()}}
\item \href{#method-fit}{\code{QDM$fit()}}
\item \href{#method-predict}{\code{QDM$predict()}}
\item \href{#method-clone}{\code{QDM$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new QDM object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QDM$new(delta = "additive", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{delta}}{[character or list] If character : "additive" or
"multiplicative". If a list is given, delta[[1]] is the delta
transform operator, and delta[[2]] its inverse.}

\item{\code{...}}{[] Named arguments passed to quantile mapping}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `QDM` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the bias correction method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QDM$fit(Y0, X0, X1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[matrix: n_samples * n_features] Observations in calibration}

\item{\code{X0}}{[matrix: n_samples * n_features] Model in calibration}

\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\if{latex}{\out{\hypertarget{method-predict}{}}}
\subsection{Method \code{predict()}}{
Predict the correction
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QDM$predict(X1, X0 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection}

\item{\code{X0}}{[matrix: n_samples * n_features or NULL] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[matrix or list] Return the matrix of correction of X1 if X0 is
                         NULL, else return a list containing Z1 and Z0,
                         the corrections of X1 and X0
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QDM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
