% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{etTrans}
\alias{etTrans}
\title{Event translation for RxODE}
\usage{
etTrans(inData, obj, addCmt = FALSE, dropUnits = FALSE,
  allTimeVar = FALSE, keepDosingOnly = FALSE, combineDvid = NULL,
  keep = character(0))
}
\arguments{
\item{inData}{Data frame to translate}

\item{obj}{Model to translate data}

\item{addCmt}{Add compartment to data frame (default code{FALSE}).}

\item{dropUnits}{Boolean to drop the units (default \code{FALSE}).}

\item{allTimeVar}{Treat all covariates as if they were time-varying}

\item{keepDosingOnly}{keep the individuals who only have dosing records and any
trailing dosing records after the last observation.}

\item{combineDvid}{is a boolean indicating if RxODE will use \code{DVID} on observation
records to change the \code{cmt} value; Useful for multiple-endpoint nlmixr models.  By default
this is determined by \code{option("RxODE.combine.dvid")} and if the option has not been set,
this is \code{TRUE}. This typically does not affect RxODE simulations.}

\item{keep}{This is a named vector of items you want to keep in the final RxODE dataset.
For added RxODE event records (if seen), last observation carried forward will be used.}
}
\value{
Object for solving in RxODE
}
\description{
Event translation for RxODE
}
\keyword{internal}
