% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentCN.R
\name{segmentCN}
\alias{segmentCN}
\title{Sengment Chinese text.}
\usage{
segmentCN(strwords, analyzer = c("default", "hmm", "jiebaR", "fmm",
  "coreNLP"), nature = FALSE, nosymbol = TRUE,
  returnType = c("vector", "tm"), ...)
}
\arguments{
\item{strwords}{A charactor vector of Chinese sentence.}

\item{analyzer}{One of 'default', 'jiebaR', 'hmm', 'fmm' and 'coreNLP'. Default is 'hmm'.}

\item{nature}{Whether to recognise the nature of the words.}

\item{nosymbol}{Whether to keep symbols in the sentence. Default is TRUE, means no symbols kept.}

\item{returnType}{Default is a string vector but we also can choose 'tm' 
to output a single string separated by space so that it can be used by \code{\link[tm]{Corpus}} directly.}

\item{...}{Other arguments.}
}
\value{
a vector of words (list if input is vecter) which have been segmented.
}
\description{
A function to segment Chinese text into words.
}
\examples{
segmentCN("hello world!")

}
\author{
Jian Li <\email{rweibo@sina.com}>
}
