\name{vcgMeshres}
\alias{vcgMeshres}
\title{calculates the average edge length of a triangular mesh}
\usage{
vcgMeshres(mesh)
}
\arguments{
  \item{mesh}{triangular mesh stored as object of class
  "mesh3d"}
}
\value{
\item{res }{average edge length (a.k.a. mesh resolution)}
\item{edgelength }{vector containing lengths for each edge}
}
\description{
calculates the average edge length of a triangular mesh,
iterating over all faces.
}
\examples{
data(humface)
mres <- vcgMeshres(humface)
#histogram of edgelength distribution
hist(mres$edgelength)
#visualise average edgelength
points( mres$res, 1000, pch=20, col=2, cex=2)
}
\author{
Stefan Schlager
}
\keyword{~kwd1}
\keyword{~kwd2}

