% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eva_functions.R
\name{tsGetNumberPerYear}
\alias{tsGetNumberPerYear}
\title{tsGetNumberPerYear}
\usage{
tsGetNumberPerYear(ms, locs)
}
\arguments{
\item{ms}{A data frame representing the time series data, where the first column contains the dates of the events.}

\item{locs}{A vector of indices representing the locations of interest in the time series.}
}
\value{
A data frame with two columns: "year" and "Freq". The "year" column contains the years, and the "Freq" column contains the number of events per year.
}
\description{
\code{tsGetNumberPerYear} is a function that calculates the number of events per year based on a given time series and a set of locations.
}
\examples{
# Create a sample time series data frame
set.seed(123)
ms <- data.frame(date = seq(as.Date("2000-01-01"), as.Date("2022-12-31"), by = "day"),
                values=rnorm(8401))
# Generate random events
events <- match(sample(ms$date, 100),ms$date)
# Get the number of events per year
tsGetNumberPerYear(ms, events)
}
