% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_functions.R
\name{tsEvaNanRunningPercentiles}
\alias{tsEvaNanRunningPercentiles}
\title{tsEvaNanRunningPercentiles}
\usage{
tsEvaNanRunningPercentiles(timeStamps, series, windowSize, percent)
}
\arguments{
\item{timeStamps}{The timestamps of the series.}

\item{series}{The input series.}

\item{windowSize}{The size of the window for the running percentile. Must be greater than or equal to 100.}

\item{percent}{The percent level to which the percentile is computed.}
}
\value{
A list containing the approximated running percentile (rnprcnt) and the standard error (stdError).
}
\description{
Computes a running percentile for a given series using a window with a specified size.
}
\details{
This function computes a running percentile for a given series using a window with a specified size.
The running percentile is computed by interpolating the percentile value for the requested percentage
based on the quitting values and incoming values in the window.
The function also performs smoothing on the output and calculates the standard error.

The function uses the following label parameters:
\describe{
\item{\code{percentDelta}}{Delta for the computation of a percentile interval around the requested percentage.
If the windowSize is greater than 2000, percentDelta is set to 1.
If the windowSize is between 1000 and 2000, percentDelta is set to 2.
If the windowSize is between 100 and 1000, percentDelta is set to 5.}
\item{\code{nLowLimit}}{Minimum number of non-NA elements for a window for percentile computation}
}
}
\examples{
timeAndSeries <- ArdecheStMartin
timeStamps <- ArdecheStMartin[,1]
series  <- ArdecheStMartin[,2]
windowSize <- 365
percent <- 90
result <- tsEvaNanRunningPercentiles(timeStamps, series, windowSize, percent)
print(result$rnprcnt)
print(result$stdError)

}
