% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_strategy.R
\name{call_strategy}
\alias{call_strategy}
\title{Calculation of search strategies.}
\usage{
call_strategy(metrics, version = "mouse_rf_6")
}
\arguments{
\item{metrics}{An \code{rtrack_metrics} object from
\code{\link{calculate_metrics}} or a list of such objects.}

\item{version}{The strategy calling model that should be used. Currently only
the default \code{mouse_rf_6} is implemented.}
}
\value{
An \code{rtrack_strategies} object. The \code{calls} element contains
  the called strategy/strategies as well as confidence scores for all
  possible strategies.
}
\description{
Calculates Morris water maze strategies from path metrics.
}
\details{
This function implements a classifier based on a trained random forest model.
}
\examples{
require(Rtrack)
track_file <- system.file("extdata", "Track_1.csv", package = "Rtrack")
arena_description <- system.file("extdata", "Arena_SW.txt", package = "Rtrack")
arena <- read_arena(arena_description)
path <- read_path(track_file, arena, track.format = "ethovision.3.csv")
metrics <- calculate_metrics(path, arena)
strategies <- call_strategy(metrics)
# Inspect the strategy call
strategies$calls

}
\seealso{
\code{\link{threshold_strategies}}, \code{\link{plot_strategies}}.
}
