% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{StoxBioticFormat}
\alias{StoxBioticFormat}
\title{StoxBiotic data format.}
\description{
The StoxBiotic data format is defined by StoX as a common format to which data from different biotic sampling formats are converted, guaranteeing consistent interpretation and documentation of all its variables.
}
\details{
The StoxBiotic format is defined according to the \code{\link[=generalSamplingHierarhcy]{general sampling hierarchy of StoX}} which is used as a basis for both the StoxcBiotic and StoxAcoustic format. The variables of the StoxBiotic format are given by the tables below:

\bold{Cruise level}:
\tabular{lllll}{
\bold{Variable} \tab \bold{Description} \tab \bold{Unit} \tab \bold{Data type} \tab \bold{Example} \cr
CruiseKey \tab Key of the Cruise table \tab None \tab Character \tab 2021105 \cr
Cruise \tab Unique Cruise identifier ("/" separated concatenation of cruise, missiontype, startyear, platform and missionnumber for NMDBiotic and LocalID for ICESBiotic) \tab None \tab Character \tab 2021105 \cr
Platform  \tab Data collection platform identifier \tab None \tab Character \tab 1019 \cr
}


\bold{Station level}:
\tabular{lllll}{
\bold{Variable} \tab \bold{Description} \tab \bold{Unit} \tab \bold{Data type} \tab \bold{Example} \cr
StationKey \tab Key of the Station level \tab None \tab 1 \cr
Station \tab Unique Station identifier \tab None \tab 2021105-1 \cr   
CatchPlatform \tab Platform performing the actual sampling (can be different from the data collection platform) \tab None \tab Character \tab 1019 \cr
DateTime \tab UTC time at start of the station \tab ISO 8601 format with milliseconds \tab Character \tab 2020-09-09T01:02:03.456Z \cr
Longitude \tab Longitude at start of the station \tab Decimal degrees \tab Numeric \tab 62.5 \cr
Latitude \tab Latitude at start of the station \tab Decimal degrees \tab Numeric \tab 5.1 \cr
BottomDepth \tab Bottom depth at start of the station \tab m \tab Numeric \tab 123 \cr
}


\bold{Haul level}:
\tabular{lllll}{
\bold{Variable} \tab \bold{Description} \tab \bold{Unit} \tab \bold{Data type} \tab \bold{Example} \cr
HaulKey \tab Key of the Haul level \tab None \tab Character \tab 2 \cr
Haul \tab Unique Haul identifier \tab None \tab Character \tab 2021105-1-2 \cr
Gear \tab Identifier of the gear \tab None \tab Character \tab 3270 \cr
TowDistance \tab Distance between start and end of the haul \tab Nautical miles \tab Numeric \tab 1.5 \cr
EffectiveTowDistance \tab Effective tow distance \tab Nautical miles \tab Numeric \tab 1.5 \cr
MinHaulDepth \tab Minimum depth of the haul (trawl headline) \tab m \tab Numeric \tab 65 \cr
MaxHaulDepth \tab Maximum depth of the haul (trawl headline) \tab m \tab Numeric \tab 35 \cr
VerticalNetOpening \tab Vertical span of the net \tab m \tab Numeric \tab 23 \cr
HorizontalNetOpening \tab Vertical span of the net \tab m \tab Numeric \tab 105 \cr
TrawlDoorSpread \tab Distance between the trawl doors \tab m \tab Numeric \tab 125 \cr
}


\bold{SpeciesCategory level}:
\tabular{lllll}{
\bold{Variable} \tab \bold{Description} \tab \bold{Unit} \tab \bold{Data type} \tab \bold{Example} \cr
SpeciesCategoryKey \tab Key of the SpeciesCategory level \tab None \tab Character \tab 126417 \cr
SpeciesCategory \tab The species category \tab None \tab Character \tab Herring \cr
}


\bold{Sample level}:
\tabular{lllll}{
\bold{Variable} \tab \bold{Description} \tab \bold{Unit} \tab \bold{Data type} \tab \bold{Example} \cr
SampleKey \tab Key of the Sample level \tab None \tab Character \tab  \cr          
Sample \tab Unique Sample identifier \tab None \tab Character \tab  \cr             
CatchFractionWeight \tab Total weight of the catch SpeciesCategory and sub category (fractions such as juveniles and adults) \tab Kg \tab Numeric \tab 49.9 \cr
CatchFractionCount \tab Total number of individuals of the catch SpeciesCategory and sub category (fractions such as juveniles and adults) \tab None \tab Numeric \tab 295 \cr 
SampleWeight \tab Total weight of the sample for individual measurements \tab Kg \tab Numeric \tab 4.6 \cr       
SampleCount \tab Size of the sample for individual measurements \tab None \tab Numeric \tab 100 \cr
}


\bold{Individual level}:
\tabular{lllll}{
\bold{Variable} \tab \bold{Description} \tab \bold{Unit} \tab \bold{Data type} \tab \bold{Example} \cr
IndividualKey \tab Key of the Individual level \tab None \tab Character \tab  \cr        
Individual \tab Unique Individual identifier \tab None \tab Character \tab  \cr           
IndividualRoundWeight \tab Round weight (the whole fish) fo the individual \tab g \tab Numeric \tab 123 \cr
IndividualTotalLength \tab Total length (from snoute to end of fin) \tab cm \tab Numeric \tab 14.5 \cr
LengthResolution \tab Resolution of IndividualTotalLength \tab cm \tab Numeric \tab 0.5 \cr     
WeightMeasurement \tab \tab None \tab Character \tab  \cr    
IndividualAge \tab Age of an individual \tab year \tab Numeric \tab 3 \cr        
IndividualSex \tab sex of an individual \tab F is female, M is male \tab Character \tab F \cr
}
}
