% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_ts.R
\name{extract_ts}
\alias{extract_ts}
\title{Extract time series parameters from data imported from 'Raven'}
\usage{
extract_ts(X, ts.column, equal.length = FALSE, as.time.series = FALSE, 
length.out = 30, parallel = 1, pb = TRUE)
}
\arguments{
\item{X}{Data frame imported from Raven. It should include at least columns for: sound file names, selection labels,
a parameters encoded as a time series (e.g. several numbers separated by semicolon)}

\item{ts.column}{Name of the column with the time series data to be extracted. 
Default is \code{NULL}.}

\item{equal.length}{Logical. Controls whether time series are kept as in the original data (most of the 
time with unequal lengths) or numbers are interpolated to equalize series length (using the \code{\link[stats]{approx}} function). All series will be interpolated to match the length of the longest series in the data. Default is \code{FALSE}.}

\item{as.time.series}{Logical. Controls if data is converted to the time series format (using the \code{\link[stats]{as.ts}} function). Default is \code{FALSE}.}

\item{length.out}{A numeric vector of length 1 giving the number of measurements to be
interpolated (the length of the time series). default is 30. Ignored if equal.length is \code{FALSE}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}
}
\value{
A data frame with columns for sound file name (sound.files), selection label (selec) and the time series for each selection.
}
\description{
\code{extract_ts} extracts time series parameters from data imported from 'Raven' bioacoustic software.
}
\details{
The function extracts parameters enconded as time series in 'Raven' selection files. The resulting data frame can be directly input into functions for time series analysis of acoustic signals as \code{\link[warbleR]{dfDTW}}.
}
\examples{

# Load data
data(selection_files)

#save 'Raven' selection tables in the temporary directory 
writeLines(selection_files[[5]], con = file.path(tempdir(), names(selection_files)[5]))

\donttest{
# import data to R
rvn.dat <- imp_raven(all.data = TRUE) 

# Peak freq dif length
extract_ts(X = rvn.dat, ts.column = "Peak.Freq.Contour..Hz.")

# Peak freq equal length
extract_ts(X = rvn.dat, ts.column = "Peak.Freq.Contour..Hz.", equal.length = T)
 
# Peak freq equal length 10 measurements
extract_ts(X = rvn.dat, ts.column = "Peak.Freq.Contour..Hz.", 
equal.length = TRUE, length.out = 10) 
} 

}
\seealso{
\code{\link{imp_raven}}; \code{\link{exp_raven}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
