% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyhedra-lib.R
\docType{class}
\name{PolyhedronStateDmccooeyScraper}
\alias{PolyhedronStateDmccooeyScraper}
\title{PolyhedronStateDmccooeyScraper}
\description{
Scrapes polyhedra from a dmccooey file format
}
\author{
ken4rab
}
\section{Super class}{
\code{\link[Rpolyhedra:PolyhedronState]{Rpolyhedra::PolyhedronState}} -> \code{PolyhedronStateDmccooeyScraper}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{regexp.values.names}}{regexp for scraping values names}

\item{\code{regexp.rn}}{regexp for scraping real numbers}

\item{\code{regexp.values}}{regexp for scraping values}

\item{\code{regexp.vertex}}{regexp for scraping vertices}

\item{\code{regexp.faces}}{regexp for scraping faces}

\item{\code{polyhedra.dmccooey.lines}}{dmccooey polyhedra definition lines}

\item{\code{labels.map}}{labels map where values are}

\item{\code{values}}{labels map where values are}

\item{\code{vertices}}{specification}

\item{\code{vertices.replaced}}{3D values}

\item{\code{faces}}{definition}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PolyhedronStateDmccooeyScraper$new()}}
\item \href{#method-setupRegexp}{\code{PolyhedronStateDmccooeyScraper$setupRegexp()}}
\item \href{#method-scrapeValues}{\code{PolyhedronStateDmccooeyScraper$scrapeValues()}}
\item \href{#method-scrapeVertices}{\code{PolyhedronStateDmccooeyScraper$scrapeVertices()}}
\item \href{#method-scrapeFaces}{\code{PolyhedronStateDmccooeyScraper$scrapeFaces()}}
\item \href{#method-scrape}{\code{PolyhedronStateDmccooeyScraper$scrape()}}
\item \href{#method-getName}{\code{PolyhedronStateDmccooeyScraper$getName()}}
\item \href{#method-applyTransformationMatrix}{\code{PolyhedronStateDmccooeyScraper$applyTransformationMatrix()}}
\item \href{#method-buildRGL}{\code{PolyhedronStateDmccooeyScraper$buildRGL()}}
\item \href{#method-exportToXML}{\code{PolyhedronStateDmccooeyScraper$exportToXML()}}
\item \href{#method-clone}{\code{PolyhedronStateDmccooeyScraper$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="Rpolyhedra" data-topic="PolyhedronState" data-id="addError">}\href{../../Rpolyhedra/html/PolyhedronState.html#method-addError}{\code{Rpolyhedra::PolyhedronState$addError()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="Rpolyhedra" data-topic="PolyhedronState" data-id="checkEdgesConsistency">}\href{../../Rpolyhedra/html/PolyhedronState.html#method-checkEdgesConsistency}{\code{Rpolyhedra::PolyhedronState$checkEdgesConsistency()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="Rpolyhedra" data-topic="PolyhedronState" data-id="getSolid">}\href{../../Rpolyhedra/html/PolyhedronState.html#method-getSolid}{\code{Rpolyhedra::PolyhedronState$getSolid()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize Dmccooey scraper
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateDmccooeyScraper$new(file.id, polyhedra.dmccooey.lines)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file.id}}{identifier of the definition file.}

\item{\code{polyhedra.dmccooey.lines}}{raw Dmccooey definition file lines}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new  PolyhedronStateDmccooeyScraper object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setupRegexp"></a>}}
\if{latex}{\out{\hypertarget{method-setupRegexp}{}}}
\subsection{Method \code{setupRegexp()}}{
setupRegexp for Dmccooey definition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateDmccooeyScraper$setupRegexp()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
This PolyhedronStateDmccooeyScraper object with regexp defined.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-scrapeValues"></a>}}
\if{latex}{\out{\hypertarget{method-scrapeValues}{}}}
\subsection{Method \code{scrapeValues()}}{
scrape values from Dmccooey definition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateDmccooeyScraper$scrapeValues(values.lines)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values.lines}}{values definitions in Dmccooey source}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This PolyhedronStateDmccooeyScraper object with values defined.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-scrapeVertices"></a>}}
\if{latex}{\out{\hypertarget{method-scrapeVertices}{}}}
\subsection{Method \code{scrapeVertices()}}{
scrape polyhedron vertices from definition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateDmccooeyScraper$scrapeVertices(vertices.lines)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vertices.lines}}{vertices definitions in Dmccooey source}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This PolyhedronStateDmccooeyScraper object with faces defined.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-scrapeFaces"></a>}}
\if{latex}{\out{\hypertarget{method-scrapeFaces}{}}}
\subsection{Method \code{scrapeFaces()}}{
scrape polyhedron faces from definition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateDmccooeyScraper$scrapeFaces(faces.lines)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{faces.lines}}{face}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This PolyhedronStateDmccooeyScraper object with faces defined.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-scrape"></a>}}
\if{latex}{\out{\hypertarget{method-scrape}{}}}
\subsection{Method \code{scrape()}}{
scrape Dmccooey polyhedron definition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateDmccooeyScraper$scrape()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new PolyhedronStateDefined object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getName"></a>}}
\if{latex}{\out{\hypertarget{method-getName}{}}}
\subsection{Method \code{getName()}}{
get Polyhedron name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateDmccooeyScraper$getName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string with polyhedron name
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-applyTransformationMatrix"></a>}}
\if{latex}{\out{\hypertarget{method-applyTransformationMatrix}{}}}
\subsection{Method \code{applyTransformationMatrix()}}{
Apply transformation matrix to polyhedron
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateDmccooeyScraper$applyTransformationMatrix(transformation.matrix)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{transformation.matrix}}{the transformation matrix to apply to the polyhedron}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-buildRGL"></a>}}
\if{latex}{\out{\hypertarget{method-buildRGL}{}}}
\subsection{Method \code{buildRGL()}}{
Creates a 'rgl' representation of the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateDmccooeyScraper$buildRGL(transformation.matrix)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{transformation.matrix}}{the transformation matrix to apply to the polyhedron}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-exportToXML"></a>}}
\if{latex}{\out{\hypertarget{method-exportToXML}{}}}
\subsection{Method \code{exportToXML()}}{
serializes object in XML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateDmccooeyScraper$exportToXML()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateDmccooeyScraper$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
