% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stages.get.deals.R
\name{stages.get.deals}
\alias{stages.get.deals}
\title{Get deals in a stage}
\usage{
stages.get.deals(id, filter_id = NULL, user_id = NULL,
  everyone = NULL, start = NULL, limit = NULL, api_token = NULL,
  company_domain = "api")
}
\arguments{
\item{id}{ID of the stage}

\item{filter_id}{If supplied, only deals matching the given filter will be returned.}

\item{user_id}{If supplied, filter_id will not be considered and only deals owned by the given user will be returned. If omitted, deals owned by the authorized user will be returned.}

\item{everyone}{If supplied, filter_id and user_id will not be considered  instead, deals owned by everyone will be returned. This field has the following domains: (0; 1)}

\item{start}{Pagination start}

\item{limit}{Items shown per page}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to Get deals in a stage from pipedrive.
}
\examples{
\donttest{
stages.get.deals(id='e.g.',api_token='token',company_domain='exp')
}
}
