% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdb.R
\name{pdb}
\alias{is.pdb}
\alias{pdb}
\alias{pdb.default}
\title{Create an Object of Class \sQuote{pdb}}
\usage{
pdb(...)

\method{pdb}{default}(atoms, cryst1 = NULL, conect = NULL, remark = NULL,
  title = NULL, ...)

is.pdb(x)
}
\arguments{
\item{atoms}{a data.frame of class \code{atoms} containing ATOM and HETATM records use to create the \code{pdb} object.}

\item{cryst1}{a list of class \code{cryst1} containing the periodical bondary conditions and space group use to create the \code{pdb} object.}

\item{conect}{a data.frame of class \code{conect} containing CONECT records use to create the \code{pdb} object.}

\item{remark}{a character vector containing some REMARK records to be added to the \code{pdb} object.}

\item{title}{a character vector containing some TITLE records to be added to the \code{pdb} object.}

\item{x}{an R object to be tested}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
\code{pdb} returns a list of class \sQuote{pdb} with the following components:
\item{title}{a character vector containing the TITLE records found in a PDB file.}
\item{remark}{a character vector containing the REMARK records found in a PDB file.}
\item{cryst1}{a list of class \sQuote{cryst1} containing the first CRYST1 record found in a PDB file. All others are ignored.}
\item{atoms}{a data.frame of class \sQuote{atoms} containing the ATOM and HETATM records found in a PDB file.}
\item{conect}{a data.frame of class \sQuote{conect} containing the CONECT records found in a PDB file.}
\cr
\code{is.pdb} returns TRUE if x is an object of class \sQuote{pdb} and FALSE otherwise.
}
\description{
Creates an object of class 'pdb'.
}
\details{
This function is the generic function to create objects of class
\sQuote{pdb}. The purpose of this class is to store the data of molecular
systems contained in PDB files. The default method of the \code{pdb} function
creates an object of class \sQuote{pdb} from its different components, i.e.:
\code{title}, \code{remark}, \code{cryst1}, \code{atoms} and \code{conect}. 
At least an object of class \sQuote{atoms} has to be specified. \cr\cr 
\code{is.pdb} tests if x is an object of class \sQuote{pdb}, i.e. if x has a
\dQuote{class} attribute equal to \code{pdb}.
}
\examples{
title  <- "This is just an example"
remark <- NULL
cryst1 <- cryst1(c(10,10,10))
atoms <- atoms(recname = c("ATOM","ATOM"), eleid = 1:2, elename = c("H","H"), alt = "",
               resname = c("H2","H2"), chainid = "", resid = c(1,1), insert = "",
               x1 = c(0,0), x2 = c(0,0), x3 = c(0,1), occ = c(0.0,0.0), temp = c(1.0,1.0),
               segid = c("H2","H2"))
conect <- conect(eleid.1 = c(1), eleid.2 = c(2))
x <- pdb(atoms = atoms, cryst1 = cryst1, conect = conect, remark = remark, title = title)
is.pdb(x)

}
\seealso{
\code{\link{atoms}}, \code{\link{coords}}, \code{\link{cryst1}}, \code{\link{conect}} and \code{\link{read.pdb}}
}
\keyword{classes}

