% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis.R
\name{basis}
\alias{basis}
\alias{basis.default}
\alias{basis.pdb}
\alias{basis<-}
\alias{basis<-.default}
\alias{basis<-.pdb}
\title{The Basis of an Object}
\usage{
basis(x)

\method{basis}{default}(x)

basis(x) <- value

\method{basis}{default}(x) <- value

\method{basis}{pdb}(x)

\method{basis}{pdb}(x) <- value
}
\arguments{
\item{x}{an R object containing atomic coordinates.}

\item{value}{a single element character vector use to set the basis of 
\code{x}.}
}
\value{
\describe{ \item{For \code{basis}:}{NULL or a single element
character vector. (NULL is given if the object has no \code{basis}
attribute.)} \item{For \code{basis<-}:}{the updated object. (Note that the
value of \code{basis(x) <- value} is that of the assignment, value, not the
return value from the left-hand side.)} }
}
\description{
Functions to get or set the basis of an object containing atomic coordinates.
}
\details{
\code{basis} and \code{basis<-} are respectively generic accessor and 
replacement functions. The default methods get and set the \code{basis} 
attribute of an object containing atomic coordinates. This attribute indicate
the type basis vector used to express atomic coordinates.\cr \code{value} 
must be equal to \code{"xyz"}, for Cartesian, or \code{"abc"}, for fractional
coordinates.\cr The methods for objects of class \sQuote{pdb} get and set the
\code{basis} attribute of its \code{atoms} component.
}
\examples{
x <- read.pdb(system.file("examples/PCBM_ODCB.pdb",package="Rpdb"))
basis(x)
x <- xyz2abc(x)
basis(x)

}
\seealso{
\code{\link{coords}}, \code{\link{atoms}}, \code{\link{pdb}}
}
\keyword{attribute}

