% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psiFuns.R
\name{rho}
\alias{rho}
\title{Rho functions}
\usage{
rho(u, family = " bisquare", cc, standardize = TRUE)
}
\arguments{
\item{u}{point or vector at which rho is to be evaluated}

\item{family}{family string specifying the name of the family of loss function to be used (current valid
options are "bisquare", "optimal" and "modopt").}

\item{cc}{tuning parameters to be computed according to efficiency and / or breakdown
considerations. See \link{lmrobdet.control}, \link{bisquare}, \link{modopt}
and \link{optimal}.}

\item{standardize}{logical value determining whether the rho function is to be
standardized so that its maximum value is 1. See \link{Mpsi}.}
}
\value{
The value(s) of \code{rho} at \code{u}
}
\description{
This function returns the value of the "rho" loss function used
to compute either an M-scale estimator or a robust regression
estimator. It currently can be used to compute the bisquare, optimal
and modified optimal loss functions.
}
\examples{
# Evaluate rho tuned for 85\% efficiency
rho(u=1.1, family='bisquare', cc=bisquare(.85))
# Evaluate rho tuned for 50\% breakdown
rho(u=1.1, family='optimal', cc=lmrobdet.control(bb=.5, family='optimal')$tuning.chi)

}
\author{
Matias Salibian-Barrera, \email{matias@stat.ubc.ca}
}
