% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RoBMA-package.R
\docType{package}
\name{RoBMA-package}
\alias{RoBMA-package}
\alias{_PACKAGE}
\title{RoBMA: Robust Bayesian Meta-Analyses}
\description{
A framework for estimating ensembles of meta-analytic models
    (assuming either presence or absence of the effect, heterogeneity, and
    publication bias) and using Bayesian model averaging to combine them. The
    ensembles use Bayes Factors to test for the presence or absence of the
    individual components (e.g., effect vs. no effect) and model-averages
    parameter estimates based on posterior model probabilities
    (Maier, Bartoš & Wagenmakers, 2020, <doi:10.31234/osf.io/u4cns>). The user can
    define a wide range of non-informative or informative priors for the
    effect size, heterogeneity, and weight functions. The package provides
    convenient functions for summary, visualizations, and fit diagnostics.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://fbartos.github.io/RoBMA/}
  \item Report bugs at \url{https://github.com/FBartos/RoBMA/issues}
}

}
\author{
\strong{Maintainer}: František Bartoš \email{f.bartos96@gmail.com} (\href{https://orcid.org/0000-0002-0018-5573}{ORCID})

Authors:
\itemize{
  \item Maximilian Maier \email{maximilianmaier0401@gmail.com} (\href{https://orcid.org/0000-0002-9873-6096}{ORCID})
}

Other contributors:
\itemize{
  \item Eric-Jan Wagenmakers (\href{https://orcid.org/0000-0003-1596-1034}{ORCID}) [thesis advisor]
  \item Joris Goosen [contributor]
}

}
\keyword{internal}
