% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getnlfilename.R
\name{getNlTifLclNameOLS}
\alias{getNlTifLclNameOLS}
\title{Constructs the filename used to save/access the decompressed OLS .tif file}
\usage{
getNlTifLclNameOLS(nlType, configName = pkgOptions(paste0("configName_",
  nlType)), nlPeriod)
}
\arguments{
\item{nlType}{The particular VIIRS type e.g. VIIRS.D for daily VIIRS}

\item{configName}{character the type of raster being processed}

\item{nlPeriod}{the nlPeriod in which the tile was created}
}
\value{
a character vector filename of the .tif VIIRS tile
}
\description{
Constructs the filename used to save/access the decompressed OLS .tif file
}
\examples{
#using default dirNlTiles
\dontrun{
Rnightlights:::getNlTifLclNameOLS("2004")
 #returns "OLS.Y_2004.tif"
 }

}
