% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\name{getCtryShpLyrName}
\alias{getCtryShpLyrName}
\title{Get the standard name of a polygon layer for a country}
\usage{
getCtryShpLyrName(ctryCode, lyrNum)
}
\arguments{
\item{ctryCode}{the ISO3 code for the country}

\item{lyrNum}{the order of the layer starting from 0 = country level, 1 = first admin level}
}
\value{
Character layer name
}
\description{
Get the standard name of a polygon layer for a country. Used to refer to a polygon layer by name.
    i.e. for CTRYCODE & lyrNum="0": lyrName="CTRYCODE_adm0", lyrNum="1": lyrName="KEN_adm1". Note this #'     is different from the country official administration level name.
}
\examples{
lyrName <- getCtryShpLyrName("KEN","0") #top layer name
  #returns "KEN_adm0"

#@export only due to exploreData() shiny app
}
