% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiles.R
\name{getCtryTileList}
\alias{getCtryTileList}
\title{Returns a list of VIIRS nightlight tiles that a country or countries
    intersects with}
\usage{
getCtryTileList(ctryCodes, nlType, omitCountries = "none")
}
\arguments{
\item{ctryCodes}{character vector of country codes to process}

\item{nlType}{character string The nlType of interest}

\item{omitCountries}{countries to exclude from processing. This is
helpful when the number of countries to exclude is smaller than
the number to process e.g. when one wants to process all countries
and exclude countries that take long to process i.e. 
omitCountries = "long"}
}
\value{
TRUE/FALSE
}
\description{
Given a list of countries, this function will provide alist of VIIRS
    nightlight tiles that intersect with them. This helps in processing
    multiple countries by determining which nightlight tiles are required
    for processing by allowing the download of all required tiles before
    processing.
}
\examples{
\dontrun{
getCtryTileList(ctryCodes=c("BUR", "KEN", "RWA", "UGA", "TZA"), 
    nlType="VIIRS", omitCountries="none")

getCtryTileList(ctryCodes="all", nlType="OLS", omitCountries="long")
}

}
