% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rte_Utils.R
\name{rte.compile.latex}
\alias{rte.compile.latex}
\title{Function to compile a LaTeX file}
\usage{
rte.compile.latex(f.in, pdf.dir.out = "PdfOut", do.clean.up = T,
  latex.compile.fct = "texi2pdf")
}
\arguments{
\item{f.in}{The location and name of latex file}

\item{pdf.dir.out}{The name of the folder for the output pdf}

\item{do.clean.up}{Clean (delete) auxiliary latex files? (TRUE or NOT)}

\item{latex.compile.fct}{Option for function compiling pdf ('texi2pdf' or 'custom')}
}
\value{
A flag, TRUE if the latex compilation was a sucess and FALSE if not
}
\description{
This function will first check for the flavor of latex, type of OS and then use the proper
command for pdflatex compilation
}
\examples{
f.in <- system.file("extdata", "MyRandomTest.tex", package = "RndTexExams")
pdf.dir.out <- 'PdfOut'

rte.compile.latex(f.in = f.in,
                 pdf.dir.out =  pdf.dir.out)

}

