% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/simulator.R
\name{print.mst_sim}
\alias{print.mst_sim}
\alias{plot.mst_sim}
\alias{sim}
\alias{mst_sim}
\title{Simulate the Administration of Multistage Tests}
\usage{
\method{print}{mst_sim}(x, ...)

\method{plot}{mst_sim}(x, ...)

mst_sim(x, true, rdp = NULL, estimator = model_mixed_eap, ...)
}
\arguments{
\item{x}{the assembled MST object}

\item{...}{additional option/control parameters}

\item{true}{the true theta parameter (numeric)}

\item{rdp}{routing decision points (list)}

\item{estimator}{the estimator of the ability parameter (function)}
}
\value{
a list of true and estimated ability theta, administered items,
and end-of-stage statistics
}
\description{
\code{mst_sim} simulates the administration of the assembled MST panel(s)
}
\details{
Use \code{theta} to set the initial theta, \code{panel} to select the MST panel,
\code{prior} to set the prior for theta estimation, \code{bounds} to set the
bounds of theta estimation, and \code{D} to set the scaling constant.
}
\examples{
## assemble a MST
items <- Rirt::model_mixed_gendata(1, n_3pl=150)$items
x <- mst(items, "1-3", 2, 'topdown', len=20, max_use=1)
x <- mst_objective(x, -1, indices=1)
x <- mst_objective(x,  0, indices=2)
x <- mst_objective(x,  1, indices=3)
x <- mst_stage_length(x, 1:2, min=5)
x <- mst_assemble(x, 'lpsolve', time_limit=2)

sim1 <- mst_sim(x, true=.5)
print(sim1)
plot(sim1)

sim2 <- mst_sim(x, true=-.5, rdp=list('stage2'=c(-.44, .44)))
print(sim2)
plot(sim2)
}
