\name{collectors}
\alias{collectors}
\title{Get Survey Collectors}
\description{Get the list of collectors for a survey}
\usage{
collectors(survey, page = NULL, page_size = NULL,
           start_date = NULL, end_date = NULL,
           name = NULL, order_asc = NULL, fields = NULL,
           api_key = getOption('sm_api_key'),
           oauth_token = getOption('sm_oauth_token'), ...)
}
\arguments{
\item{survey}{A Survey Monkey survey ID number (or an object of class \dQuote{sm_survey} from which it can be extracted), possibly returned by \code{\link{surveylist}}.}
\item{page}{A number indicating which page of results to return.}
\item{page_size}{The number of results to return per API call. Default is 1000.}
\item{start_date}{A start datetime to restrict result to. Any returned collectors must have been created on or after this datetime. Required format is \code{YYYY-MM-DD HH:MM:SS}, implicitly in UTC; if argument is of class \code{POSIXct}, formatting is handled automatically.}
\item{end_date}{An end datetime to restrict result to. Any returned collectors must have been created strictly before this datetime. Required format is \code{YYYY-MM-DD HH:MM:SS}, implicitly in UTC; if argument is of class \code{POSIXct}, formatting is handled automatically.}
\item{name}{A character string containing a name of a survey collector to search for.}
\item{order_asc}{A boolean indicating whether results should be sorted in ascending or descending (the default) order.}
\item{fields}{A character vector containing the names of fields to return in each \code{sm_collector} class object. See Details.}
\item{api_key}{Your API key. By default, retrieved from \code{getOption('sm_api_key')}.}
\item{oauth_token}{Your OAuth 2.0 token, as generated by \code{\link{smlogin}}. By default, retrieved from \code{getOption('sm_oauth_token')}.}
\item{...}{Other arguments passed to \code{\link[httr]{POST}}.}
}
\details{Retrieves the list of collectors for a specified survey.

The \code{fields} argument accepts one or more the following values: \code{url}, \code{open}, \code{type}, \code{name}, \code{date_created}, \code{date_modified}.
}
\value{A list of objects of class \code{sm_collector}.}
\references{
\url{https://developer.surveymonkey.com/mashery/get_collector_list}
}
\author{Thomas J. Leeper}
%\note{}
%\seealso{}
\examples{
\dontrun{
smlogin()
s <- surveylist()
collectors(s[[1]]$survey_id)
}
}
%\keyword{}
