// Generated by rstantools.  Do not edit by hand.

/*
    rstanarm is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rstanarm is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rstanarm.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_S2GT_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'S2GT', line 44, column 2 to column 21)",
                                                      " (in 'S2GT', line 44, column 22 to column 37)",
                                                      " (in 'S2GT', line 45, column 1 to column 36)",
                                                      " (in 'S2GT', line 46, column 1 to column 21)",
                                                      " (in 'S2GT', line 47, column 1 to column 29)",
                                                      " (in 'S2GT', line 48, column 1 to column 30)",
                                                      " (in 'S2GT', line 49, column 1 to column 27)",
                                                      " (in 'S2GT', line 50, column 1 to column 28)",
                                                      " (in 'S2GT', line 51, column 1 to column 28)",
                                                      " (in 'S2GT', line 52, column 1 to column 37)",
                                                      " (in 'S2GT', line 53, column 1 to column 16)",
                                                      " (in 'S2GT', line 54, column 1 to column 36)",
                                                      " (in 'S2GT', line 55, column 1 to column 31)",
                                                      " (in 'S2GT', line 56, column 1 to column 30)",
                                                      " (in 'S2GT', line 57, column 1 to column 27)",
                                                      " (in 'S2GT', line 58, column 1 to column 34)",
                                                      " (in 'S2GT', line 59, column 1 to column 29)",
                                                      " (in 'S2GT', line 60, column 1 to column 35)",
                                                      " (in 'S2GT', line 63, column 1 to column 56)",
                                                      " (in 'S2GT', line 64, column 1 to column 22)",
                                                      " (in 'S2GT', line 65, column 1 to column 23)",
                                                      " (in 'S2GT', line 66, column 1 to column 27)",
                                                      " (in 'S2GT', line 67, column 1 to column 29)",
                                                      " (in 'S2GT', line 68, column 1 to column 13)",
                                                      " (in 'S2GT', line 69, column 1 to column 27)",
                                                      " (in 'S2GT', line 70, column 1 to column 38)",
                                                      " (in 'S2GT', line 71, column 1 to column 19)",
                                                      " (in 'S2GT', line 72, column 1 to column 20)",
                                                      " (in 'S2GT', line 73, column 1 to column 12)",
                                                      " (in 'S2GT', line 74, column 1 to column 16)",
                                                      " (in 'S2GT', line 75, column 1 to column 16)",
                                                      " (in 'S2GT', line 80, column 2 to column 21)",
                                                      " (in 'S2GT', line 78, column 2 to column 33)",
                                                      " (in 'S2GT', line 77, column 1 to line 80, column 21)",
                                                      " (in 'S2GT', line 99, column 3 to column 19)",
                                                      " (in 'S2GT', line 98, column 2 to line 99, column 19)",
                                                      " (in 'S2GT', line 101, column 6 to column 24)",
                                                      " (in 'S2GT', line 100, column 2 to line 101, column 24)",
                                                      " (in 'S2GT', line 102, column 2 to column 21)",
                                                      " (in 'S2GT', line 97, column 9 to line 103, column 2)",
                                                      " (in 'S2GT', line 83, column 2 to column 12)",
                                                      " (in 'S2GT', line 85, column 3 to column 32)",
                                                      " (in 'S2GT', line 84, column 2 to line 85, column 32)",
                                                      " (in 'S2GT', line 87, column 3 to column 42)",
                                                      " (in 'S2GT', line 86, column 27 to line 89, column 3)",
                                                      " (in 'S2GT', line 86, column 2 to line 89, column 3)",
                                                      " (in 'S2GT', line 90, column 2 to column 12)",
                                                      " (in 'S2GT', line 92, column 3 to column 33)",
                                                      " (in 'S2GT', line 91, column 2 to line 92, column 33)",
                                                      " (in 'S2GT', line 94, column 3 to column 45)",
                                                      " (in 'S2GT', line 93, column 2 to line 94, column 45)",
                                                      " (in 'S2GT', line 96, column 2 to column 34)",
                                                      " (in 'S2GT', line 82, column 25 to line 97, column 2)",
                                                      " (in 'S2GT', line 82, column 1 to line 103, column 2)",
                                                      " (in 'S2GT', line 104, column 1 to column 22)",
                                                      " (in 'S2GT', line 105, column 1 to column 25)",
                                                      " (in 'S2GT', line 106, column 1 to column 25)",
                                                      " (in 'S2GT', line 108, column 1 to column 24)",
                                                      " (in 'S2GT', line 109, column 1 to column 28)",
                                                      " (in 'S2GT', line 110, column 1 to column 28)",
                                                      " (in 'S2GT', line 115, column 3 to column 26)",
                                                      " (in 'S2GT', line 113, column 3 to column 38)",
                                                      " (in 'S2GT', line 112, column 1 to line 115, column 26)",
                                                      " (in 'S2GT', line 117, column 1 to column 68)",
                                                      " (in 'S2GT', line 118, column 1 to column 18)",
                                                      " (in 'S2GT', line 123, column 2 to column 22)",
                                                      " (in 'S2GT', line 121, column 2 to column 13)",
                                                      " (in 'S2GT', line 120, column 1 to line 123, column 22)",
                                                      " (in 'S2GT', line 127, column 2 to column 22)",
                                                      " (in 'S2GT', line 129, column 3 to column 33)",
                                                      " (in 'S2GT', line 128, column 2 to line 129, column 33)",
                                                      " (in 'S2GT', line 130, column 2 to column 35)",
                                                      " (in 'S2GT', line 134, column 4 to column 21)",
                                                      " (in 'S2GT', line 133, column 3 to line 134, column 21)",
                                                      " (in 'S2GT', line 132, column 2 to line 134, column 21)",
                                                      " (in 'S2GT', line 126, column 26 to line 135, column 2)",
                                                      " (in 'S2GT', line 126, column 1 to line 135, column 2)",
                                                      " (in 'S2GT', line 139, column 3 to column 73)",
                                                      " (in 'S2GT', line 138, column 2 to line 139, column 73)",
                                                      " (in 'S2GT', line 147, column 3 to column 104)",
                                                      " (in 'S2GT', line 149, column 4 to column 76)",
                                                      " (in 'S2GT', line 148, column 3 to line 149, column 76)",
                                                      " (in 'S2GT', line 146, column 9 to line 150, column 3)",
                                                      " (in 'S2GT', line 143, column 3 to column 67)",
                                                      " (in 'S2GT', line 145, column 4 to column 39)",
                                                      " (in 'S2GT', line 144, column 3 to line 145, column 39)",
                                                      " (in 'S2GT', line 142, column 27 to line 146, column 3)",
                                                      " (in 'S2GT', line 142, column 2 to line 150, column 3)",
                                                      " (in 'S2GT', line 158, column 3 to column 48)",
                                                      " (in 'S2GT', line 162, column 5 to column 60)",
                                                      " (in 'S2GT', line 160, column 5 to column 16)",
                                                      " (in 'S2GT', line 159, column 3 to line 162, column 60)",
                                                      " (in 'S2GT', line 157, column 34 to line 163, column 3)",
                                                      " (in 'S2GT', line 157, column 8 to line 163, column 3)",
                                                      " (in 'S2GT', line 156, column 3 to column 55)",
                                                      " (in 'S2GT', line 155, column 7 to line 163, column 3)",
                                                      " (in 'S2GT', line 154, column 3 to column 46)",
                                                      " (in 'S2GT', line 153, column 2 to line 163, column 3)",
                                                      " (in 'S2GT', line 170, column 3 to column 95)",
                                                      " (in 'S2GT', line 171, column 6 to column 100)",
                                                      " (in 'S2GT', line 169, column 9 to line 172, column 3)",
                                                      " (in 'S2GT', line 167, column 3 to column 62)",
                                                      " (in 'S2GT', line 168, column 3 to column 63)",
                                                      " (in 'S2GT', line 166, column 27 to line 169, column 3)",
                                                      " (in 'S2GT', line 166, column 2 to line 172, column 3)",
                                                      " (in 'S2GT', line 178, column 6 to column 36)",
                                                      " (in 'S2GT', line 175, column 6 to column 38)",
                                                      " (in 'S2GT', line 176, column 6 to column 91)",
                                                      " (in 'S2GT', line 174, column 26 to line 177, column 6)",
                                                      " (in 'S2GT', line 174, column 2 to line 178, column 36)",
                                                      " (in 'S2GT', line 184, column 6 to column 39)",
                                                      " (in 'S2GT', line 181, column 6 to column 41)",
                                                      " (in 'S2GT', line 182, column 6 to column 98)",
                                                      " (in 'S2GT', line 180, column 27 to line 183, column 6)",
                                                      " (in 'S2GT', line 180, column 2 to line 184, column 39)",
                                                      " (in 'S2GT', line 190, column 3 to column 26)",
                                                      " (in 'S2GT', line 188, column 3 to column 87)",
                                                      " (in 'S2GT', line 187, column 2 to line 190, column 26)",
                                                      " (in 'S2GT', line 137, column 16 to line 191, column 2)",
                                                      " (in 'S2GT', line 137, column 1 to line 191, column 2)",
                                                      " (in 'S2GT', line 194, column 31 to column 32)",
                                                      " (in 'S2GT', line 194, column 1 to column 35)",
                                                      " (in 'S2GT', line 195, column 45 to column 54)",
                                                      " (in 'S2GT', line 195, column 1 to column 57)",
                                                      " (in 'S2GT', line 196, column 1 to column 34)",
                                                      " (in 'S2GT', line 197, column 1 to column 54)",
                                                      " (in 'S2GT', line 198, column 1 to column 20)",
                                                      " (in 'S2GT', line 203, column 34 to column 35)",
                                                      " (in 'S2GT', line 203, column 3 to column 38)",
                                                      " (in 'S2GT', line 200, column 1 to line 203, column 38)",
                                                      " (in 'S2GT', line 201, column 47 to column 48)",
                                                      " (in 'S2GT', line 201, column 2 to column 51)",
                                                      " (in 'S2GT', line 209, column 2 to column 25)",
                                                      " (in 'S2GT', line 210, column 2 to column 27)",
                                                      " (in 'S2GT', line 208, column 8 to line 211, column 2)",
                                                      " (in 'S2GT', line 206, column 2 to column 37)",
                                                      " (in 'S2GT', line 207, column 2 to column 38)",
                                                      " (in 'S2GT', line 205, column 21 to line 208, column 2)",
                                                      " (in 'S2GT', line 205, column 1 to line 211, column 2)",
                                                      " (in 'S2GT', line 219, column 2 to column 54)",
                                                      " (in 'S2GT', line 220, column 2 to column 55)",
                                                      " (in 'S2GT', line 222, column 3 to column 35)",
                                                      " (in 'S2GT', line 221, column 2 to line 222, column 35)",
                                                      " (in 'S2GT', line 224, column 3 to column 36)",
                                                      " (in 'S2GT', line 223, column 2 to line 224, column 36)",
                                                      " (in 'S2GT', line 218, column 8 to line 225, column 2)",
                                                      " (in 'S2GT', line 215, column 6 to column 31)",
                                                      " (in 'S2GT', line 214, column 2 to line 215, column 31)",
                                                      " (in 'S2GT', line 217, column 3 to column 29)",
                                                      " (in 'S2GT', line 216, column 5 to line 217, column 29)",
                                                      " (in 'S2GT', line 213, column 26 to line 218, column 2)",
                                                      " (in 'S2GT', line 213, column 1 to line 225, column 2)",
                                                      " (in 'S2GT', line 231, column 4 to column 80)",
                                                      " (in 'S2GT', line 229, column 4 to column 71)",
                                                      " (in 'S2GT', line 228, column 3 to line 231, column 80)",
                                                      " (in 'S2GT', line 227, column 16 to line 232, column 2)",
                                                      " (in 'S2GT', line 227, column 1 to line 232, column 2)",
                                                      " (in 'S2GT', line 3, column 1 to column 26)",
                                                      " (in 'S2GT', line 4, column 1 to column 59)",
                                                      " (in 'S2GT', line 5, column 1 to column 39)",
                                                      " (in 'S2GT', line 6, column 1 to column 62)",
                                                      " (in 'S2GT', line 7, column 1 to column 25)",
                                                      " (in 'S2GT', line 8, column 1 to column 20)",
                                                      " (in 'S2GT', line 8, column 22 to column 41)",
                                                      " (in 'S2GT', line 9, column 1 to column 25)",
                                                      " (in 'S2GT', line 10, column 1 to column 22)",
                                                      " (in 'S2GT', line 10, column 23 to column 44)",
                                                      " (in 'S2GT', line 11, column 1 to column 39)",
                                                      " (in 'S2GT', line 12, column 17 to column 18)",
                                                      " (in 'S2GT', line 12, column 1 to column 22)",
                                                      " (in 'S2GT', line 13, column 1 to column 31)",
                                                      " (in 'S2GT', line 13, column 32 to column 61)",
                                                      " (in 'S2GT', line 14, column 1 to column 32)",
                                                      " (in 'S2GT', line 14, column 33 to column 63)",
                                                      " (in 'S2GT', line 15, column 1 to column 37)",
                                                      " (in 'S2GT', line 16, column 1 to column 39)",
                                                      " (in 'S2GT', line 17, column 1 to column 41)",
                                                      " (in 'S2GT', line 18, column 1 to column 40)",
                                                      " (in 'S2GT', line 19, column 1 to column 40)",
                                                      " (in 'S2GT', line 20, column 1 to column 16)",
                                                      " (in 'S2GT', line 21, column 8 to column 9)",
                                                      " (in 'S2GT', line 21, column 11 to column 12)",
                                                      " (in 'S2GT', line 21, column 1 to column 19)",
                                                      " (in 'S2GT', line 22, column 17 to column 18)",
                                                      " (in 'S2GT', line 22, column 1 to column 34)",
                                                      " (in 'S2GT', line 25, column 1 to column 41)",
                                                      " (in 'S2GT', line 26, column 1 to column 42)",
                                                      " (in 'S2GT', line 27, column 1 to column 51)",
                                                      " (in 'S2GT', line 34, column 2 to column 21)",
                                                      " (in 'S2GT', line 30, column 2 to column 45)",
                                                      " (in 'S2GT', line 29, column 32 to line 32, column 2)",
                                                      " (in 'S2GT', line 29, column 1 to line 34, column 21)",
                                                      " (in 'S2GT', line 41, column 2 to column 22)",
                                                      " (in 'S2GT', line 37, column 2 to column 48)",
                                                      " (in 'S2GT', line 36, column 34 to line 39, column 2)",
                                                      " (in 'S2GT', line 36, column 1 to line 41, column 22)",
                                                      " (in 'S2GT', line 44, column 9 to column 10)",
                                                      " (in 'S2GT', line 57, column 8 to column 19)",
                                                      " (in 'S2GT', line 59, column 8 to column 20)",
                                                      " (in 'S2GT', line 64, column 17 to column 18)",
                                                      " (in 'S2GT', line 65, column 17 to column 18)",
                                                      " (in 'S2GT', line 66, column 8 to column 23)",
                                                      " (in 'S2GT', line 67, column 8 to column 24)",
                                                      " (in 'S2GT', line 68, column 8 to column 9)",
                                                      " (in 'S2GT', line 69, column 17 to column 18)",
                                                      " (in 'S2GT', line 70, column 17 to column 18)"};
#include <stan_meta_header.hpp>
class model_S2GT final : public model_base_crtp<model_S2GT> {
private:
  int SEASONALITY;
  double SEASONALITY_F;
  int SEASONALITY2;
  double SEASONALITY2_F;
  double CAUCHY_SD;
  double MIN_POW_TREND;
  double MAX_POW_TREND;
  double MIN_SIGMA;
  double MIN_NU;
  double MAX_NU;
  int N;
  Eigen::Matrix<double, -1, 1> y;
  double POW_TREND_ALPHA;
  double POW_TREND_BETA;
  double POW_SEASON_ALPHA;
  double POW_SEASON_BETA;
  int USE_REGRESSION;
  int SEASONALITY_TYPE;
  int USE_SMOOTHED_ERROR;
  int NUM_OF_SEASON_INIT_CYCLES;
  int LEVEL_CALC_METHOD;
  int J;
  Eigen::Matrix<double, -1, -1> xreg;
  Eigen::Matrix<double, -1, 1> REG_CAUCHY_SD;
  double fractSeasonality;
  double fractSeasonality2;
  double reg0CauchySd;
  int s_1dim__;
  int s2_1dim__;
 
public:
  ~model_S2GT() { }
  
  inline std::string model_name() const final { return "model_S2GT"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_S2GT(stan::io::var_context& context__,
             unsigned int random_seed__ = 0,
             std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_S2GT_namespace::model_S2GT";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 158;
      context__.validate_dims("data initialization","SEASONALITY","int",
          context__.to_vec());
      SEASONALITY = std::numeric_limits<int>::min();
      
      current_statement__ = 158;
      SEASONALITY = context__.vals_i("SEASONALITY")[(1 - 1)];
      current_statement__ = 158;
      current_statement__ = 158;
      check_greater_or_equal(function__, "SEASONALITY", SEASONALITY, 2);
      current_statement__ = 159;
      context__.validate_dims("data initialization","SEASONALITY_F","double",
          context__.to_vec());
      SEASONALITY_F = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 159;
      SEASONALITY_F = context__.vals_r("SEASONALITY_F")[(1 - 1)];
      current_statement__ = 159;
      current_statement__ = 159;
      check_greater_or_equal(function__, "SEASONALITY_F", SEASONALITY_F,
                             SEASONALITY);
      current_statement__ = 159;
      current_statement__ = 159;
      check_less_or_equal(function__, "SEASONALITY_F", SEASONALITY_F,
                          (SEASONALITY + 1));
      current_statement__ = 160;
      context__.validate_dims("data initialization","SEASONALITY2","int",
          context__.to_vec());
      SEASONALITY2 = std::numeric_limits<int>::min();
      
      current_statement__ = 160;
      SEASONALITY2 = context__.vals_i("SEASONALITY2")[(1 - 1)];
      current_statement__ = 160;
      current_statement__ = 160;
      check_greater_or_equal(function__, "SEASONALITY2", SEASONALITY2,
                             (SEASONALITY + 1));
      current_statement__ = 161;
      context__.validate_dims("data initialization","SEASONALITY2_F",
          "double",context__.to_vec());
      SEASONALITY2_F = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 161;
      SEASONALITY2_F = context__.vals_r("SEASONALITY2_F")[(1 - 1)];
      current_statement__ = 161;
      current_statement__ = 161;
      check_greater_or_equal(function__, "SEASONALITY2_F", SEASONALITY2_F,
                             SEASONALITY2);
      current_statement__ = 161;
      current_statement__ = 161;
      check_less_or_equal(function__, "SEASONALITY2_F", SEASONALITY2_F,
                          (SEASONALITY2 + 1));
      current_statement__ = 162;
      context__.validate_dims("data initialization","CAUCHY_SD","double",
          context__.to_vec());
      CAUCHY_SD = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 162;
      CAUCHY_SD = context__.vals_r("CAUCHY_SD")[(1 - 1)];
      current_statement__ = 162;
      current_statement__ = 162;
      check_greater_or_equal(function__, "CAUCHY_SD", CAUCHY_SD, 0);
      current_statement__ = 163;
      context__.validate_dims("data initialization","MIN_POW_TREND","double",
          context__.to_vec());
      MIN_POW_TREND = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 163;
      MIN_POW_TREND = context__.vals_r("MIN_POW_TREND")[(1 - 1)];
      current_statement__ = 164;
      context__.validate_dims("data initialization","MAX_POW_TREND","double",
          context__.to_vec());
      MAX_POW_TREND = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 164;
      MAX_POW_TREND = context__.vals_r("MAX_POW_TREND")[(1 - 1)];
      current_statement__ = 165;
      context__.validate_dims("data initialization","MIN_SIGMA","double",
          context__.to_vec());
      MIN_SIGMA = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 165;
      MIN_SIGMA = context__.vals_r("MIN_SIGMA")[(1 - 1)];
      current_statement__ = 165;
      current_statement__ = 165;
      check_greater_or_equal(function__, "MIN_SIGMA", MIN_SIGMA, 0);
      current_statement__ = 166;
      context__.validate_dims("data initialization","MIN_NU","double",
          context__.to_vec());
      MIN_NU = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 166;
      MIN_NU = context__.vals_r("MIN_NU")[(1 - 1)];
      current_statement__ = 166;
      current_statement__ = 166;
      check_greater_or_equal(function__, "MIN_NU", MIN_NU, 1);
      current_statement__ = 167;
      context__.validate_dims("data initialization","MAX_NU","double",
          context__.to_vec());
      MAX_NU = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 167;
      MAX_NU = context__.vals_r("MAX_NU")[(1 - 1)];
      current_statement__ = 167;
      current_statement__ = 167;
      check_greater_or_equal(function__, "MAX_NU", MAX_NU, 1);
      current_statement__ = 168;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 168;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 168;
      current_statement__ = 168;
      check_greater_or_equal(function__, "N", N, (SEASONALITY + SEASONALITY2));
      current_statement__ = 169;
      validate_non_negative_index("y", "N", N);
      current_statement__ = 170;
      context__.validate_dims("data initialization","y","double",
          context__.to_vec(N));
      y = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 170;
        assign(y_flat__, nil_index_list(), context__.vals_r("y"),
          "assigning variable y_flat__");
        current_statement__ = 170;
        pos__ = 1;
        current_statement__ = 170;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 170;
          assign(y, cons_list(index_uni(sym1__), nil_index_list()),
            y_flat__[(pos__ - 1)], "assigning variable y");
          current_statement__ = 170;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 170;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 170;
        current_statement__ = 170;
        check_greater_or_equal(function__, "y[sym1__]", y[(sym1__ - 1)], 0);}
      current_statement__ = 171;
      context__.validate_dims("data initialization","POW_TREND_ALPHA",
          "double",context__.to_vec());
      POW_TREND_ALPHA = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 171;
      POW_TREND_ALPHA = context__.vals_r("POW_TREND_ALPHA")[(1 - 1)];
      current_statement__ = 171;
      current_statement__ = 171;
      check_greater_or_equal(function__, "POW_TREND_ALPHA", POW_TREND_ALPHA,
                             0);
      current_statement__ = 172;
      context__.validate_dims("data initialization","POW_TREND_BETA",
          "double",context__.to_vec());
      POW_TREND_BETA = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 172;
      POW_TREND_BETA = context__.vals_r("POW_TREND_BETA")[(1 - 1)];
      current_statement__ = 172;
      current_statement__ = 172;
      check_greater_or_equal(function__, "POW_TREND_BETA", POW_TREND_BETA, 0);
      current_statement__ = 173;
      context__.validate_dims("data initialization","POW_SEASON_ALPHA",
          "double",context__.to_vec());
      POW_SEASON_ALPHA = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 173;
      POW_SEASON_ALPHA = context__.vals_r("POW_SEASON_ALPHA")[(1 - 1)];
      current_statement__ = 173;
      current_statement__ = 173;
      check_greater_or_equal(function__, "POW_SEASON_ALPHA",
                             POW_SEASON_ALPHA, 0);
      current_statement__ = 174;
      context__.validate_dims("data initialization","POW_SEASON_BETA",
          "double",context__.to_vec());
      POW_SEASON_BETA = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 174;
      POW_SEASON_BETA = context__.vals_r("POW_SEASON_BETA")[(1 - 1)];
      current_statement__ = 174;
      current_statement__ = 174;
      check_greater_or_equal(function__, "POW_SEASON_BETA", POW_SEASON_BETA,
                             0);
      current_statement__ = 175;
      context__.validate_dims("data initialization","USE_REGRESSION","int",
          context__.to_vec());
      USE_REGRESSION = std::numeric_limits<int>::min();
      
      current_statement__ = 175;
      USE_REGRESSION = context__.vals_i("USE_REGRESSION")[(1 - 1)];
      current_statement__ = 175;
      current_statement__ = 175;
      check_greater_or_equal(function__, "USE_REGRESSION", USE_REGRESSION, 0);
      current_statement__ = 175;
      current_statement__ = 175;
      check_less_or_equal(function__, "USE_REGRESSION", USE_REGRESSION, 1);
      current_statement__ = 176;
      context__.validate_dims("data initialization","SEASONALITY_TYPE","int",
          context__.to_vec());
      SEASONALITY_TYPE = std::numeric_limits<int>::min();
      
      current_statement__ = 176;
      SEASONALITY_TYPE = context__.vals_i("SEASONALITY_TYPE")[(1 - 1)];
      current_statement__ = 176;
      current_statement__ = 176;
      check_greater_or_equal(function__, "SEASONALITY_TYPE",
                             SEASONALITY_TYPE, 0);
      current_statement__ = 176;
      current_statement__ = 176;
      check_less_or_equal(function__, "SEASONALITY_TYPE", SEASONALITY_TYPE, 1);
      current_statement__ = 177;
      context__.validate_dims("data initialization","USE_SMOOTHED_ERROR",
          "int",context__.to_vec());
      USE_SMOOTHED_ERROR = std::numeric_limits<int>::min();
      
      current_statement__ = 177;
      USE_SMOOTHED_ERROR = context__.vals_i("USE_SMOOTHED_ERROR")[(1 - 1)];
      current_statement__ = 177;
      current_statement__ = 177;
      check_greater_or_equal(function__, "USE_SMOOTHED_ERROR",
                             USE_SMOOTHED_ERROR, 0);
      current_statement__ = 177;
      current_statement__ = 177;
      check_less_or_equal(function__, "USE_SMOOTHED_ERROR",
                          USE_SMOOTHED_ERROR, 1);
      current_statement__ = 178;
      context__.validate_dims("data initialization",
          "NUM_OF_SEASON_INIT_CYCLES","int",context__.to_vec());
      NUM_OF_SEASON_INIT_CYCLES = std::numeric_limits<int>::min();
      
      current_statement__ = 178;
      NUM_OF_SEASON_INIT_CYCLES = context__.vals_i("NUM_OF_SEASON_INIT_CYCLES")[
          (1 - 1)];
      current_statement__ = 178;
      current_statement__ = 178;
      check_greater_or_equal(function__, "NUM_OF_SEASON_INIT_CYCLES",
                             NUM_OF_SEASON_INIT_CYCLES, 0);
      current_statement__ = 179;
      context__.validate_dims("data initialization","LEVEL_CALC_METHOD",
          "int",context__.to_vec());
      LEVEL_CALC_METHOD = std::numeric_limits<int>::min();
      
      current_statement__ = 179;
      LEVEL_CALC_METHOD = context__.vals_i("LEVEL_CALC_METHOD")[(1 - 1)];
      current_statement__ = 179;
      current_statement__ = 179;
      check_greater_or_equal(function__, "LEVEL_CALC_METHOD",
                             LEVEL_CALC_METHOD, 0);
      current_statement__ = 179;
      current_statement__ = 179;
      check_less_or_equal(function__, "LEVEL_CALC_METHOD", LEVEL_CALC_METHOD,
                          3);
      current_statement__ = 180;
      context__.validate_dims("data initialization","J","int",
          context__.to_vec());
      J = std::numeric_limits<int>::min();
      
      current_statement__ = 180;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 180;
      current_statement__ = 180;
      check_greater_or_equal(function__, "J", J, 1);
      current_statement__ = 181;
      validate_non_negative_index("xreg", "N", N);
      current_statement__ = 182;
      validate_non_negative_index("xreg", "J", J);
      current_statement__ = 183;
      context__.validate_dims("data initialization","xreg","double",
          context__.to_vec(N, J));
      xreg = Eigen::Matrix<double, -1, -1>(N, J);
      stan::math::fill(xreg, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xreg_flat__;
        current_statement__ = 183;
        assign(xreg_flat__, nil_index_list(), context__.vals_r("xreg"),
          "assigning variable xreg_flat__");
        current_statement__ = 183;
        pos__ = 1;
        current_statement__ = 183;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 183;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 183;
            assign(xreg,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xreg_flat__[(pos__ - 1)], "assigning variable xreg");
            current_statement__ = 183;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 184;
      validate_non_negative_index("REG_CAUCHY_SD", "J", J);
      current_statement__ = 185;
      context__.validate_dims("data initialization","REG_CAUCHY_SD","double",
          context__.to_vec(J));
      REG_CAUCHY_SD = Eigen::Matrix<double, -1, 1>(J);
      stan::math::fill(REG_CAUCHY_SD, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> REG_CAUCHY_SD_flat__;
        current_statement__ = 185;
        assign(REG_CAUCHY_SD_flat__, nil_index_list(),
          context__.vals_r("REG_CAUCHY_SD"),
          "assigning variable REG_CAUCHY_SD_flat__");
        current_statement__ = 185;
        pos__ = 1;
        current_statement__ = 185;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 185;
          assign(REG_CAUCHY_SD,
            cons_list(index_uni(sym1__), nil_index_list()),
            REG_CAUCHY_SD_flat__[(pos__ - 1)],
            "assigning variable REG_CAUCHY_SD");
          current_statement__ = 185;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 185;
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        current_statement__ = 185;
        current_statement__ = 185;
        check_greater_or_equal(function__, "REG_CAUCHY_SD[sym1__]",
                               REG_CAUCHY_SD[(sym1__ - 1)], 0);}
      current_statement__ = 186;
      fractSeasonality = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 187;
      fractSeasonality2 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 188;
      reg0CauchySd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 188;
      reg0CauchySd = (mean(REG_CAUCHY_SD) * 10);
      current_statement__ = 192;
      if (logical_gt(SEASONALITY_F, SEASONALITY)) {
        current_statement__ = 190;
        fractSeasonality = (SEASONALITY_F - SEASONALITY);
      } else {
        current_statement__ = 189;
        fractSeasonality = 0;
      }
      current_statement__ = 196;
      if (logical_gt(SEASONALITY2_F, SEASONALITY2)) {
        current_statement__ = 194;
        fractSeasonality2 = (SEASONALITY2_F - SEASONALITY2);
      } else {
        current_statement__ = 193;
        fractSeasonality2 = 0;
      }
      current_statement__ = 186;
      current_statement__ = 186;
      check_greater_or_equal(function__, "fractSeasonality",
                             fractSeasonality, 0);
      current_statement__ = 186;
      current_statement__ = 186;
      check_less_or_equal(function__, "fractSeasonality", fractSeasonality, 1);
      current_statement__ = 187;
      current_statement__ = 187;
      check_greater_or_equal(function__, "fractSeasonality2",
                             fractSeasonality2, 0);
      current_statement__ = 187;
      current_statement__ = 187;
      check_less_or_equal(function__, "fractSeasonality2", fractSeasonality2,
                          1);
      current_statement__ = 188;
      current_statement__ = 188;
      check_greater_or_equal(function__, "reg0CauchySd", reg0CauchySd, 0);
      current_statement__ = 197;
      validate_non_negative_index("regCoef", "J", J);
      current_statement__ = 198;
      validate_non_negative_index("initS", "SEASONALITY", SEASONALITY);
      current_statement__ = 199;
      validate_non_negative_index("initS2", "SEASONALITY2", SEASONALITY2);
      current_statement__ = 200;
      validate_non_negative_index("l", "N", N);
      current_statement__ = 201;
      validate_non_negative_index("l0", "N", N);
      current_statement__ = 202;
      s_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 202;
      s_1dim__ = ((N + SEASONALITY) + 1);
      current_statement__ = 202;
      validate_non_negative_index("s", "N + SEASONALITY + 1", s_1dim__);
      current_statement__ = 203;
      s2_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 203;
      s2_1dim__ = ((N + SEASONALITY2) + 1);
      current_statement__ = 203;
      validate_non_negative_index("s2", "N + SEASONALITY2 + 1", s2_1dim__);
      current_statement__ = 204;
      validate_non_negative_index("r", "N", N);
      current_statement__ = 205;
      validate_non_negative_index("expVal", "N", N);
      current_statement__ = 206;
      validate_non_negative_index("smoothedInnovSize", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += J;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += SEASONALITY;
      num_params_r__ += 1;
      num_params_r__ += SEASONALITY2;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_S2GT_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> regCoef;
      regCoef = Eigen::Matrix<local_scalar_t__, -1, 1>(J);
      stan::math::fill(regCoef, DUMMY_VAR__);
      
      current_statement__ = 1;
      regCoef = in__.vector(J);
      local_scalar_t__ regOffset;
      regOffset = DUMMY_VAR__;
      
      current_statement__ = 2;
      regOffset = in__.scalar();
      local_scalar_t__ nu;
      nu = DUMMY_VAR__;
      
      current_statement__ = 3;
      nu = in__.scalar();
      current_statement__ = 3;
      if (jacobian__) {
        current_statement__ = 3;
        nu = stan::math::lub_constrain(nu, MIN_NU, MAX_NU, lp__);
      } else {
        current_statement__ = 3;
        nu = stan::math::lub_constrain(nu, MIN_NU, MAX_NU);
      }
      local_scalar_t__ sigma;
      sigma = DUMMY_VAR__;
      
      current_statement__ = 4;
      sigma = in__.scalar();
      current_statement__ = 4;
      if (jacobian__) {
        current_statement__ = 4;
        sigma = stan::math::lb_constrain(sigma, 0, lp__);
      } else {
        current_statement__ = 4;
        sigma = stan::math::lb_constrain(sigma, 0);
      }
      local_scalar_t__ levSm;
      levSm = DUMMY_VAR__;
      
      current_statement__ = 5;
      levSm = in__.scalar();
      current_statement__ = 5;
      if (jacobian__) {
        current_statement__ = 5;
        levSm = stan::math::lub_constrain(levSm, 0, 1, lp__);
      } else {
        current_statement__ = 5;
        levSm = stan::math::lub_constrain(levSm, 0, 1);
      }
      local_scalar_t__ llevSm;
      llevSm = DUMMY_VAR__;
      
      current_statement__ = 6;
      llevSm = in__.scalar();
      current_statement__ = 6;
      if (jacobian__) {
        current_statement__ = 6;
        llevSm = stan::math::lub_constrain(llevSm, 0, 1, lp__);
      } else {
        current_statement__ = 6;
        llevSm = stan::math::lub_constrain(llevSm, 0, 1);
      }
      local_scalar_t__ sSm;
      sSm = DUMMY_VAR__;
      
      current_statement__ = 7;
      sSm = in__.scalar();
      current_statement__ = 7;
      if (jacobian__) {
        current_statement__ = 7;
        sSm = stan::math::lub_constrain(sSm, 0, 1, lp__);
      } else {
        current_statement__ = 7;
        sSm = stan::math::lub_constrain(sSm, 0, 1);
      }
      local_scalar_t__ s2Sm;
      s2Sm = DUMMY_VAR__;
      
      current_statement__ = 8;
      s2Sm = in__.scalar();
      current_statement__ = 8;
      if (jacobian__) {
        current_statement__ = 8;
        s2Sm = stan::math::lub_constrain(s2Sm, 0, 1, lp__);
      } else {
        current_statement__ = 8;
        s2Sm = stan::math::lub_constrain(s2Sm, 0, 1);
      }
      local_scalar_t__ powx;
      powx = DUMMY_VAR__;
      
      current_statement__ = 9;
      powx = in__.scalar();
      current_statement__ = 9;
      if (jacobian__) {
        current_statement__ = 9;
        powx = stan::math::lub_constrain(powx, 0, 1, lp__);
      } else {
        current_statement__ = 9;
        powx = stan::math::lub_constrain(powx, 0, 1);
      }
      local_scalar_t__ powTrendBeta;
      powTrendBeta = DUMMY_VAR__;
      
      current_statement__ = 10;
      powTrendBeta = in__.scalar();
      current_statement__ = 10;
      if (jacobian__) {
        current_statement__ = 10;
        powTrendBeta = stan::math::lub_constrain(powTrendBeta, 0, 1, lp__);
      } else {
        current_statement__ = 10;
        powTrendBeta = stan::math::lub_constrain(powTrendBeta, 0, 1);
      }
      local_scalar_t__ coefTrend;
      coefTrend = DUMMY_VAR__;
      
      current_statement__ = 11;
      coefTrend = in__.scalar();
      local_scalar_t__ offsetSigma;
      offsetSigma = DUMMY_VAR__;
      
      current_statement__ = 12;
      offsetSigma = in__.scalar();
      current_statement__ = 12;
      if (jacobian__) {
        current_statement__ = 12;
        offsetSigma = stan::math::lb_constrain(offsetSigma, MIN_SIGMA, lp__);
      } else {
        current_statement__ = 12;
        offsetSigma = stan::math::lb_constrain(offsetSigma, MIN_SIGMA);
      }
      local_scalar_t__ innovSm;
      innovSm = DUMMY_VAR__;
      
      current_statement__ = 13;
      innovSm = in__.scalar();
      current_statement__ = 13;
      if (jacobian__) {
        current_statement__ = 13;
        innovSm = stan::math::lub_constrain(innovSm, 0, 1, lp__);
      } else {
        current_statement__ = 13;
        innovSm = stan::math::lub_constrain(innovSm, 0, 1);
      }
      local_scalar_t__ innovSizeInit;
      innovSizeInit = DUMMY_VAR__;
      
      current_statement__ = 14;
      innovSizeInit = in__.scalar();
      current_statement__ = 14;
      if (jacobian__) {
        current_statement__ = 14;
        innovSizeInit = stan::math::lb_constrain(innovSizeInit, 0, lp__);
      } else {
        current_statement__ = 14;
        innovSizeInit = stan::math::lb_constrain(innovSizeInit, 0);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> initS;
      initS = Eigen::Matrix<local_scalar_t__, -1, 1>(SEASONALITY);
      stan::math::fill(initS, DUMMY_VAR__);
      
      current_statement__ = 15;
      initS = in__.vector(SEASONALITY);
      local_scalar_t__ powSeason;
      powSeason = DUMMY_VAR__;
      
      current_statement__ = 16;
      powSeason = in__.scalar();
      current_statement__ = 16;
      if (jacobian__) {
        current_statement__ = 16;
        powSeason = stan::math::lub_constrain(powSeason, 0, 1, lp__);
      } else {
        current_statement__ = 16;
        powSeason = stan::math::lub_constrain(powSeason, 0, 1);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> initS2;
      initS2 = Eigen::Matrix<local_scalar_t__, -1, 1>(SEASONALITY2);
      stan::math::fill(initS2, DUMMY_VAR__);
      
      current_statement__ = 17;
      initS2 = in__.vector(SEASONALITY2);
      local_scalar_t__ powSeason2;
      powSeason2 = DUMMY_VAR__;
      
      current_statement__ = 18;
      powSeason2 = in__.scalar();
      current_statement__ = 18;
      if (jacobian__) {
        current_statement__ = 18;
        powSeason2 = stan::math::lub_constrain(powSeason2, 0, 1, lp__);
      } else {
        current_statement__ = 18;
        powSeason2 = stan::math::lub_constrain(powSeason2, 0, 1);
      }
      local_scalar_t__ powTrend;
      powTrend = DUMMY_VAR__;
      
      Eigen::Matrix<local_scalar_t__, -1, 1> l;
      l = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(l, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> l0;
      l0 = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(l0, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> s;
      s = Eigen::Matrix<local_scalar_t__, -1, 1>(s_1dim__);
      stan::math::fill(s, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> s2;
      s2 = Eigen::Matrix<local_scalar_t__, -1, 1>(s2_1dim__);
      stan::math::fill(s2, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> r;
      r = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(r, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> expVal;
      expVal = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(expVal, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> smoothedInnovSize;
      smoothedInnovSize = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(smoothedInnovSize, DUMMY_VAR__);
      
      local_scalar_t__ seasonalityP;
      seasonalityP = DUMMY_VAR__;
      
      local_scalar_t__ seasonalityP2;
      seasonalityP2 = DUMMY_VAR__;
      
      local_scalar_t__ sumsu;
      sumsu = DUMMY_VAR__;
      
      local_scalar_t__ newLevelP;
      newLevelP = DUMMY_VAR__;
      
      local_scalar_t__ movingSum;
      movingSum = DUMMY_VAR__;
      
      current_statement__ = 34;
      if (USE_REGRESSION) {
        current_statement__ = 33;
        assign(r, nil_index_list(), add(multiply(xreg, regCoef), regOffset),
          "assigning variable r");
      } else {
        current_statement__ = 32;
        assign(r, nil_index_list(), rep_vector(0, N), "assigning variable r");
      }
      current_statement__ = 54;
      if (logical_eq(SEASONALITY_TYPE, 0)) {
        current_statement__ = 41;
        sumsu = 0;
        current_statement__ = 43;
        for (int i = 1; i <= SEASONALITY; ++i) {
          current_statement__ = 42;
          sumsu = (sumsu + stan::math::exp(initS[(i - 1)]));}
        current_statement__ = 46;
        for (int i = 1; i <= SEASONALITY; ++i) {
          current_statement__ = 44;
          assign(s, cons_list(index_uni(i), nil_index_list()),
            ((stan::math::exp(initS[(i - 1)]) * SEASONALITY) / sumsu),
            "assigning variable s");}
        current_statement__ = 47;
        sumsu = 0;
        current_statement__ = 49;
        for (int i = 1; i <= SEASONALITY2; ++i) {
          current_statement__ = 48;
          sumsu = (sumsu + stan::math::exp(initS2[(i - 1)]));}
        current_statement__ = 51;
        for (int i = 1; i <= SEASONALITY2; ++i) {
          current_statement__ = 50;
          assign(s2, cons_list(index_uni(i), nil_index_list()),
            ((stan::math::exp(initS2[(i - 1)]) * SEASONALITY2) / sumsu),
            "assigning variable s2");}
        current_statement__ = 52;
        assign(l, cons_list(index_uni(1), nil_index_list()),
          ((y[(1 - 1)] - r[(1 - 1)]) / (s[(1 - 1)] * s2[(1 - 1)])),
          "assigning variable l");
      } else {
        current_statement__ = 36;
        for (int i = 1; i <= SEASONALITY; ++i) {
          current_statement__ = 35;
          assign(s, cons_list(index_uni(i), nil_index_list()),
            initS[(i - 1)], "assigning variable s");}
        current_statement__ = 38;
        for (int i = 1; i <= SEASONALITY2; ++i) {
          current_statement__ = 37;
          assign(s2, cons_list(index_uni(i), nil_index_list()),
            initS2[(i - 1)], "assigning variable s2");}
        current_statement__ = 39;
        assign(l, cons_list(index_uni(1), nil_index_list()),
          (y[(1 - 1)] - r[(1 - 1)]), "assigning variable l");
      }
      current_statement__ = 55;
      assign(s,
        cons_list(index_uni(((N + SEASONALITY) + 1)), nil_index_list()), 1,
        "assigning variable s");
      current_statement__ = 56;
      assign(s, cons_list(index_uni((SEASONALITY + 1)), nil_index_list()),
        s[(1 - 1)], "assigning variable s");
      current_statement__ = 57;
      assign(s, cons_list(index_uni((SEASONALITY + 2)), nil_index_list()),
        s[(2 - 1)], "assigning variable s");
      current_statement__ = 58;
      assign(s2,
        cons_list(index_uni(((N + SEASONALITY2) + 1)), nil_index_list()), 1,
        "assigning variable s2");
      current_statement__ = 59;
      assign(s2, cons_list(index_uni((SEASONALITY2 + 1)), nil_index_list()),
        s2[(1 - 1)], "assigning variable s2");
      current_statement__ = 60;
      assign(s2, cons_list(index_uni((SEASONALITY2 + 2)), nil_index_list()),
        s2[(2 - 1)], "assigning variable s2");
      current_statement__ = 63;
      if (USE_SMOOTHED_ERROR) {
        current_statement__ = 62;
        assign(smoothedInnovSize, cons_list(index_uni(1), nil_index_list()),
          innovSizeInit, "assigning variable smoothedInnovSize");
      } else {
        current_statement__ = 61;
        assign(smoothedInnovSize, cons_list(index_uni(1), nil_index_list()),
          1, "assigning variable smoothedInnovSize");
      }
      current_statement__ = 64;
      powTrend = (((MAX_POW_TREND - MIN_POW_TREND) * powTrendBeta) +
                   MIN_POW_TREND);
      current_statement__ = 65;
      assign(expVal, cons_list(index_uni(1), nil_index_list()), y[(1 - 1)],
        "assigning variable expVal");
      current_statement__ = 68;
      if (logical_eq(LEVEL_CALC_METHOD, 3)) {
        current_statement__ = 67;
        assign(l0, cons_list(index_uni(1), nil_index_list()), l[(1 - 1)],
          "assigning variable l0");
      } else {
        current_statement__ = 66;
        assign(l0, nil_index_list(), rep_vector(0, N),
          "assigning variable l0");
      }
      current_statement__ = 77;
      if (logical_gt(LEVEL_CALC_METHOD, 0)) {
        current_statement__ = 69;
        movingSum = (y[(1 - 1)] - r[(1 - 1)]);
        current_statement__ = 71;
        for (int t = 2; t <= SEASONALITY2; ++t) {
          current_statement__ = 70;
          movingSum = ((movingSum + y[(t - 1)]) - r[(t - 1)]);}
        current_statement__ = 72;
        newLevelP = (movingSum / SEASONALITY2);
        current_statement__ = 75;
        if (logical_eq(LEVEL_CALC_METHOD, 2)) {
          current_statement__ = 74;
          for (int t = 1; t <= SEASONALITY2; ++t) {
            current_statement__ = 73;
            assign(l, cons_list(index_uni(t), nil_index_list()), newLevelP,
              "assigning variable l");}
        } 
      } 
      current_statement__ = 120;
      for (int t = 2; t <= N; ++t) {
        current_statement__ = 79;
        if ((primitive_value(logical_gt(LEVEL_CALC_METHOD, 0)) &&
            primitive_value(logical_gt(t, SEASONALITY2)))) {
          current_statement__ = 78;
          movingSum = ((movingSum + (y[(t - 1)] - r[(t - 1)])) -
                        (y[((t - SEASONALITY2) - 1)] -
                          r[((t - SEASONALITY2) - 1)]));
        } 
        current_statement__ = 88;
        if (logical_eq(SEASONALITY_TYPE, 0)) {
          current_statement__ = 84;
          assign(expVal, cons_list(index_uni(t), nil_index_list()),
            ((((l[((t - 1) - 1)] +
                 (coefTrend * pow(l[((t - 1) - 1)], powTrend))) * s[(t - 1)])
               * s2[(t - 1)]) + r[(t - 1)]), "assigning variable expVal");
          current_statement__ = 86;
          if (logical_neq(LEVEL_CALC_METHOD, 2)) {
            current_statement__ = 85;
            newLevelP = ((y[(t - 1)] - r[(t - 1)]) /
                          (s[(t - 1)] * s2[(t - 1)]));
          } 
        } else {
          current_statement__ = 80;
          assign(expVal, cons_list(index_uni(t), nil_index_list()),
            ((((l[((t - 1) - 1)] +
                 (coefTrend * pow(l[((t - 1) - 1)], powTrend))) +
                (s[(t - 1)] * pow(l[((t - 1) - 1)], powSeason))) +
               (s2[(t - 1)] * pow(l[((t - 1) - 1)], powSeason2))) +
              r[(t - 1)]), "assigning variable expVal");
          current_statement__ = 82;
          if (logical_neq(LEVEL_CALC_METHOD, 2)) {
            current_statement__ = 81;
            newLevelP = (((y[(t - 1)] - r[(t - 1)]) -
                           (s[(t - 1)] * pow(l[((t - 1) - 1)], powSeason))) -
                          (s2[(t - 1)] * pow(l[((t - 1) - 1)], powSeason2)));
          } 
        }
        current_statement__ = 98;
        if (logical_eq(LEVEL_CALC_METHOD, 0)) {
          current_statement__ = 97;
          assign(l, cons_list(index_uni(t), nil_index_list()),
            ((levSm * newLevelP) + ((1 - levSm) * l[((t - 1) - 1)])),
            "assigning variable l");
        } else {
          current_statement__ = 96;
          if ((primitive_value(logical_eq(LEVEL_CALC_METHOD, 2)) &&
              primitive_value(logical_gt(t, SEASONALITY)))) {
            current_statement__ = 95;
            assign(l, cons_list(index_uni(t), nil_index_list()),
              (((levSm * movingSum) / SEASONALITY2) +
                ((1 - levSm) * l[((t - 1) - 1)])), "assigning variable l");
          } else {
            current_statement__ = 94;
            if (logical_eq(LEVEL_CALC_METHOD, 3)) {
              current_statement__ = 89;
              assign(l0, cons_list(index_uni(t), nil_index_list()),
                ((levSm * newLevelP) + ((1 - levSm) * l0[((t - 1) - 1)])),
                "assigning variable l0");
              current_statement__ = 92;
              if (logical_lte(t, SEASONALITY2)) {
                current_statement__ = 91;
                assign(l, cons_list(index_uni(t), nil_index_list()),
                  l0[(t - 1)], "assigning variable l");
              } else {
                current_statement__ = 90;
                assign(l, cons_list(index_uni(t), nil_index_list()),
                  ((llevSm * l0[(t - 1)]) +
                    (((1 - llevSm) * movingSum) / SEASONALITY2)),
                  "assigning variable l");
              }
            } 
          }
        }
        current_statement__ = 105;
        if (logical_eq(SEASONALITY_TYPE, 0)) {
          current_statement__ = 102;
          seasonalityP = (((sSm * (y[(t - 1)] - r[(t - 1)])) /
                            (l[(t - 1)] * s2[(t - 1)])) +
                           ((1 - sSm) * s[(t - 1)]));
          current_statement__ = 103;
          seasonalityP2 = (((s2Sm * (y[(t - 1)] - r[(t - 1)])) /
                             (l[(t - 1)] * s[(t - 1)])) +
                            ((1 - s2Sm) * s2[(t - 1)]));
        } else {
          current_statement__ = 99;
          seasonalityP = (((sSm *
                             (((y[(t - 1)] - l[(t - 1)]) -
                                (s2[(t - 1)] * pow(l[(t - 1)], powSeason2)))
                               - r[(t - 1)])) / pow(l[(t - 1)], powSeason)) +
                           ((1 - sSm) * s[(t - 1)]));
          current_statement__ = 100;
          seasonalityP2 = (((s2Sm *
                              (((y[(t - 1)] - l[(t - 1)]) -
                                 (s[(t - 1)] * pow(l[(t - 1)], powSeason))) -
                                r[(t - 1)])) / pow(l[(t - 1)], powSeason2)) +
                            ((1 - s2Sm) * s2[(t - 1)]));
        }
        current_statement__ = 110;
        if (logical_gt(fractSeasonality, 0)) {
          current_statement__ = 107;
          assign(s,
            cons_list(index_uni(((t + SEASONALITY) + 1)), nil_index_list()),
            seasonalityP, "assigning variable s");
          current_statement__ = 108;
          assign(s,
            cons_list(index_uni((t + SEASONALITY)), nil_index_list()),
            ((fractSeasonality * s[((t + SEASONALITY) - 1)]) +
              ((1 - fractSeasonality) * seasonalityP)),
            "assigning variable s");
        } else {
          current_statement__ = 106;
          assign(s,
            cons_list(index_uni((t + SEASONALITY)), nil_index_list()),
            seasonalityP, "assigning variable s");
        }
        current_statement__ = 115;
        if (logical_gt(fractSeasonality2, 0)) {
          current_statement__ = 112;
          assign(s2,
            cons_list(index_uni(((t + SEASONALITY2) + 1)), nil_index_list()),
            seasonalityP2, "assigning variable s2");
          current_statement__ = 113;
          assign(s2,
            cons_list(index_uni((t + SEASONALITY2)), nil_index_list()),
            ((fractSeasonality2 * s2[((t + SEASONALITY2) - 1)]) +
              ((1 - fractSeasonality2) * seasonalityP2)),
            "assigning variable s2");
        } else {
          current_statement__ = 111;
          assign(s2,
            cons_list(index_uni((t + SEASONALITY2)), nil_index_list()),
            seasonalityP2, "assigning variable s2");
        }
        current_statement__ = 118;
        if (USE_SMOOTHED_ERROR) {
          current_statement__ = 117;
          assign(smoothedInnovSize,
            cons_list(index_uni(t), nil_index_list()),
            ((innovSm * stan::math::abs((y[(t - 1)] - expVal[(t - 1)]))) +
              ((1 - innovSm) * smoothedInnovSize[((t - 1) - 1)])),
            "assigning variable smoothedInnovSize");
        } else {
          current_statement__ = 116;
          assign(smoothedInnovSize,
            cons_list(index_uni(t), nil_index_list()), 1,
            "assigning variable smoothedInnovSize");
        }}
      current_statement__ = 19;
      current_statement__ = 19;
      check_greater_or_equal(function__, "powTrend", powTrend, MIN_POW_TREND);
      current_statement__ = 19;
      current_statement__ = 19;
      check_less_or_equal(function__, "powTrend", powTrend, MAX_POW_TREND);
      current_statement__ = 20;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 20;
        current_statement__ = 20;
        check_greater_or_equal(function__, "l[sym1__]", l[(sym1__ - 1)], 0);}
      current_statement__ = 21;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 21;
        current_statement__ = 21;
        check_greater_or_equal(function__, "l0[sym1__]", l0[(sym1__ - 1)], 0);
      }
      current_statement__ = 25;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 25;
        current_statement__ = 25;
        check_greater_or_equal(function__, "expVal[sym1__]",
                               expVal[(sym1__ - 1)], 0);}
      current_statement__ = 26;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 26;
        current_statement__ = 26;
        check_greater_or_equal(function__, "smoothedInnovSize[sym1__]",
                               smoothedInnovSize[(sym1__ - 1)], 0);}
      {
        current_statement__ = 121;
        if (logical_lt(sigma, 0)) {
          current_statement__ = 121;
          lp_accum__.add(stan::math::negative_infinity());
        } else {
          current_statement__ = 121;
          lp_accum__.add(-cauchy_ccdf_log(0, 0, CAUCHY_SD));
        }
        current_statement__ = 122;
        lp_accum__.add(cauchy_lpdf<propto__>(sigma, 0, CAUCHY_SD));
        current_statement__ = 123;
        if (logical_lt(offsetSigma, MIN_SIGMA)) {
          current_statement__ = 123;
          lp_accum__.add(stan::math::negative_infinity());
        } else {
          current_statement__ = 123;
          lp_accum__.add(-cauchy_ccdf_log(MIN_SIGMA, MIN_SIGMA, CAUCHY_SD));
        }
        current_statement__ = 124;
        lp_accum__.add(
          cauchy_lpdf<propto__>(offsetSigma, MIN_SIGMA, CAUCHY_SD));
        current_statement__ = 125;
        lp_accum__.add(cauchy_lpdf<propto__>(coefTrend, 0, CAUCHY_SD));
        current_statement__ = 126;
        lp_accum__.add(
          beta_lpdf<propto__>(powTrendBeta, POW_TREND_ALPHA, POW_TREND_BETA));
        current_statement__ = 127;
        lp_accum__.add(beta_lpdf<propto__>(levSm, 1, 2));
        current_statement__ = 130;
        if (USE_SMOOTHED_ERROR) {
          current_statement__ = 131;
          if (logical_lt(innovSizeInit, 0)) {
            current_statement__ = 131;
            lp_accum__.add(stan::math::negative_infinity());
          } else {
            current_statement__ = 131;
            lp_accum__.add(-cauchy_ccdf_log(0, (y[(1 - 1)] / 100), CAUCHY_SD));
          }
          current_statement__ = 132;
          lp_accum__.add(
            cauchy_lpdf<propto__>(innovSizeInit, (y[(1 - 1)] / 100),
              CAUCHY_SD));
        } else {
          current_statement__ = 128;
          if (logical_lt(innovSizeInit, 0)) {
            current_statement__ = 128;
            lp_accum__.add(stan::math::negative_infinity());
          } else {
            current_statement__ = 128;
            lp_accum__.add(-normal_ccdf_log(0, 0, 1));
          }
          current_statement__ = 129;
          lp_accum__.add(normal_lpdf<propto__>(innovSizeInit, 0, 1));
        }
        current_statement__ = 139;
        if (USE_REGRESSION) {
          current_statement__ = 136;
          lp_accum__.add(cauchy_lpdf<propto__>(regCoef, 0, REG_CAUCHY_SD));
          current_statement__ = 137;
          lp_accum__.add(cauchy_lpdf<propto__>(regOffset, 0, reg0CauchySd));
        } else {
          current_statement__ = 133;
          lp_accum__.add(normal_lpdf<propto__>(regCoef, 0, 1));
          current_statement__ = 134;
          lp_accum__.add(normal_lpdf<propto__>(regOffset, 0, 1));
        }
        current_statement__ = 152;
        if (logical_eq(SEASONALITY_TYPE, 0)) {
          current_statement__ = 148;
          for (int t = 1; t <= SEASONALITY; ++t) {
            current_statement__ = 147;
            lp_accum__.add(cauchy_lpdf<propto__>(initS[(t - 1)], 0, 4));}
          current_statement__ = 150;
          for (int t = 1; t <= SEASONALITY2; ++t) {
            current_statement__ = 149;
            lp_accum__.add(cauchy_lpdf<propto__>(initS2[(t - 1)], 0, 4));}
        } else {
          current_statement__ = 140;
          lp_accum__.add(
            beta_lpdf<propto__>(powSeason, POW_SEASON_ALPHA, POW_SEASON_BETA));
          current_statement__ = 141;
          lp_accum__.add(
            beta_lpdf<propto__>(powSeason2, POW_SEASON_ALPHA,
              POW_SEASON_BETA));
          current_statement__ = 143;
          for (int t = 1; t <= SEASONALITY; ++t) {
            current_statement__ = 142;
            lp_accum__.add(
              cauchy_lpdf<propto__>(initS[(t - 1)], 0, (y[(t - 1)] * 0.3)));}
          current_statement__ = 145;
          for (int t = 1; t <= SEASONALITY2; ++t) {
            current_statement__ = 144;
            lp_accum__.add(
              cauchy_lpdf<propto__>(initS2[(t - 1)], 0, (y[(t - 1)] * 0.3)));
          }
        }
        current_statement__ = 157;
        for (int t = 2; t <= N; ++t) {
          current_statement__ = 155;
          if (logical_eq(USE_SMOOTHED_ERROR, 0)) {
            current_statement__ = 154;
            lp_accum__.add(
              student_t_lpdf<propto__>(y[(t - 1)], nu, expVal[(t - 1)],
                ((sigma * pow(expVal[(t - 1)], powx)) + offsetSigma)));
          } else {
            current_statement__ = 153;
            lp_accum__.add(
              student_t_lpdf<propto__>(y[(t - 1)], nu, expVal[(t - 1)],
                ((sigma * smoothedInnovSize[((t - 1) - 1)]) + offsetSigma)));
          }}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_S2GT_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> regCoef;
      regCoef = Eigen::Matrix<double, -1, 1>(J);
      stan::math::fill(regCoef, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      regCoef = in__.vector(J);
      double regOffset;
      regOffset = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      regOffset = in__.scalar();
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      nu = in__.scalar();
      current_statement__ = 3;
      nu = stan::math::lub_constrain(nu, MIN_NU, MAX_NU);
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma = in__.scalar();
      current_statement__ = 4;
      sigma = stan::math::lb_constrain(sigma, 0);
      double levSm;
      levSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      levSm = in__.scalar();
      current_statement__ = 5;
      levSm = stan::math::lub_constrain(levSm, 0, 1);
      double llevSm;
      llevSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      llevSm = in__.scalar();
      current_statement__ = 6;
      llevSm = stan::math::lub_constrain(llevSm, 0, 1);
      double sSm;
      sSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      sSm = in__.scalar();
      current_statement__ = 7;
      sSm = stan::math::lub_constrain(sSm, 0, 1);
      double s2Sm;
      s2Sm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      s2Sm = in__.scalar();
      current_statement__ = 8;
      s2Sm = stan::math::lub_constrain(s2Sm, 0, 1);
      double powx;
      powx = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      powx = in__.scalar();
      current_statement__ = 9;
      powx = stan::math::lub_constrain(powx, 0, 1);
      double powTrendBeta;
      powTrendBeta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 10;
      powTrendBeta = in__.scalar();
      current_statement__ = 10;
      powTrendBeta = stan::math::lub_constrain(powTrendBeta, 0, 1);
      double coefTrend;
      coefTrend = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 11;
      coefTrend = in__.scalar();
      double offsetSigma;
      offsetSigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 12;
      offsetSigma = in__.scalar();
      current_statement__ = 12;
      offsetSigma = stan::math::lb_constrain(offsetSigma, MIN_SIGMA);
      double innovSm;
      innovSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 13;
      innovSm = in__.scalar();
      current_statement__ = 13;
      innovSm = stan::math::lub_constrain(innovSm, 0, 1);
      double innovSizeInit;
      innovSizeInit = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 14;
      innovSizeInit = in__.scalar();
      current_statement__ = 14;
      innovSizeInit = stan::math::lb_constrain(innovSizeInit, 0);
      Eigen::Matrix<double, -1, 1> initS;
      initS = Eigen::Matrix<double, -1, 1>(SEASONALITY);
      stan::math::fill(initS, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 15;
      initS = in__.vector(SEASONALITY);
      double powSeason;
      powSeason = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 16;
      powSeason = in__.scalar();
      current_statement__ = 16;
      powSeason = stan::math::lub_constrain(powSeason, 0, 1);
      Eigen::Matrix<double, -1, 1> initS2;
      initS2 = Eigen::Matrix<double, -1, 1>(SEASONALITY2);
      stan::math::fill(initS2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 17;
      initS2 = in__.vector(SEASONALITY2);
      double powSeason2;
      powSeason2 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 18;
      powSeason2 = in__.scalar();
      current_statement__ = 18;
      powSeason2 = stan::math::lub_constrain(powSeason2, 0, 1);
      double powTrend;
      powTrend = std::numeric_limits<double>::quiet_NaN();
      
      Eigen::Matrix<double, -1, 1> l;
      l = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(l, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> l0;
      l0 = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(l0, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> s;
      s = Eigen::Matrix<double, -1, 1>(s_1dim__);
      stan::math::fill(s, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> s2;
      s2 = Eigen::Matrix<double, -1, 1>(s2_1dim__);
      stan::math::fill(s2, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> r;
      r = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(r, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> expVal;
      expVal = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(expVal, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> smoothedInnovSize;
      smoothedInnovSize = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(smoothedInnovSize, std::numeric_limits<double>::quiet_NaN());
      
      double seasonalityP;
      seasonalityP = std::numeric_limits<double>::quiet_NaN();
      
      double seasonalityP2;
      seasonalityP2 = std::numeric_limits<double>::quiet_NaN();
      
      double sumsu;
      sumsu = std::numeric_limits<double>::quiet_NaN();
      
      double newLevelP;
      newLevelP = std::numeric_limits<double>::quiet_NaN();
      
      double movingSum;
      movingSum = std::numeric_limits<double>::quiet_NaN();
      
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        vars__.emplace_back(regCoef[(sym1__ - 1)]);}
      vars__.emplace_back(regOffset);
      vars__.emplace_back(nu);
      vars__.emplace_back(sigma);
      vars__.emplace_back(levSm);
      vars__.emplace_back(llevSm);
      vars__.emplace_back(sSm);
      vars__.emplace_back(s2Sm);
      vars__.emplace_back(powx);
      vars__.emplace_back(powTrendBeta);
      vars__.emplace_back(coefTrend);
      vars__.emplace_back(offsetSigma);
      vars__.emplace_back(innovSm);
      vars__.emplace_back(innovSizeInit);
      for (int sym1__ = 1; sym1__ <= SEASONALITY; ++sym1__) {
        vars__.emplace_back(initS[(sym1__ - 1)]);}
      vars__.emplace_back(powSeason);
      for (int sym1__ = 1; sym1__ <= SEASONALITY2; ++sym1__) {
        vars__.emplace_back(initS2[(sym1__ - 1)]);}
      vars__.emplace_back(powSeason2);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 34;
      if (USE_REGRESSION) {
        current_statement__ = 33;
        assign(r, nil_index_list(), add(multiply(xreg, regCoef), regOffset),
          "assigning variable r");
      } else {
        current_statement__ = 32;
        assign(r, nil_index_list(), rep_vector(0, N), "assigning variable r");
      }
      current_statement__ = 54;
      if (logical_eq(SEASONALITY_TYPE, 0)) {
        current_statement__ = 41;
        sumsu = 0;
        current_statement__ = 43;
        for (int i = 1; i <= SEASONALITY; ++i) {
          current_statement__ = 42;
          sumsu = (sumsu + stan::math::exp(initS[(i - 1)]));}
        current_statement__ = 46;
        for (int i = 1; i <= SEASONALITY; ++i) {
          current_statement__ = 44;
          assign(s, cons_list(index_uni(i), nil_index_list()),
            ((stan::math::exp(initS[(i - 1)]) * SEASONALITY) / sumsu),
            "assigning variable s");}
        current_statement__ = 47;
        sumsu = 0;
        current_statement__ = 49;
        for (int i = 1; i <= SEASONALITY2; ++i) {
          current_statement__ = 48;
          sumsu = (sumsu + stan::math::exp(initS2[(i - 1)]));}
        current_statement__ = 51;
        for (int i = 1; i <= SEASONALITY2; ++i) {
          current_statement__ = 50;
          assign(s2, cons_list(index_uni(i), nil_index_list()),
            ((stan::math::exp(initS2[(i - 1)]) * SEASONALITY2) / sumsu),
            "assigning variable s2");}
        current_statement__ = 52;
        assign(l, cons_list(index_uni(1), nil_index_list()),
          ((y[(1 - 1)] - r[(1 - 1)]) / (s[(1 - 1)] * s2[(1 - 1)])),
          "assigning variable l");
      } else {
        current_statement__ = 36;
        for (int i = 1; i <= SEASONALITY; ++i) {
          current_statement__ = 35;
          assign(s, cons_list(index_uni(i), nil_index_list()),
            initS[(i - 1)], "assigning variable s");}
        current_statement__ = 38;
        for (int i = 1; i <= SEASONALITY2; ++i) {
          current_statement__ = 37;
          assign(s2, cons_list(index_uni(i), nil_index_list()),
            initS2[(i - 1)], "assigning variable s2");}
        current_statement__ = 39;
        assign(l, cons_list(index_uni(1), nil_index_list()),
          (y[(1 - 1)] - r[(1 - 1)]), "assigning variable l");
      }
      current_statement__ = 55;
      assign(s,
        cons_list(index_uni(((N + SEASONALITY) + 1)), nil_index_list()), 1,
        "assigning variable s");
      current_statement__ = 56;
      assign(s, cons_list(index_uni((SEASONALITY + 1)), nil_index_list()),
        s[(1 - 1)], "assigning variable s");
      current_statement__ = 57;
      assign(s, cons_list(index_uni((SEASONALITY + 2)), nil_index_list()),
        s[(2 - 1)], "assigning variable s");
      current_statement__ = 58;
      assign(s2,
        cons_list(index_uni(((N + SEASONALITY2) + 1)), nil_index_list()), 1,
        "assigning variable s2");
      current_statement__ = 59;
      assign(s2, cons_list(index_uni((SEASONALITY2 + 1)), nil_index_list()),
        s2[(1 - 1)], "assigning variable s2");
      current_statement__ = 60;
      assign(s2, cons_list(index_uni((SEASONALITY2 + 2)), nil_index_list()),
        s2[(2 - 1)], "assigning variable s2");
      current_statement__ = 63;
      if (USE_SMOOTHED_ERROR) {
        current_statement__ = 62;
        assign(smoothedInnovSize, cons_list(index_uni(1), nil_index_list()),
          innovSizeInit, "assigning variable smoothedInnovSize");
      } else {
        current_statement__ = 61;
        assign(smoothedInnovSize, cons_list(index_uni(1), nil_index_list()),
          1, "assigning variable smoothedInnovSize");
      }
      current_statement__ = 64;
      powTrend = (((MAX_POW_TREND - MIN_POW_TREND) * powTrendBeta) +
                   MIN_POW_TREND);
      current_statement__ = 65;
      assign(expVal, cons_list(index_uni(1), nil_index_list()), y[(1 - 1)],
        "assigning variable expVal");
      current_statement__ = 68;
      if (logical_eq(LEVEL_CALC_METHOD, 3)) {
        current_statement__ = 67;
        assign(l0, cons_list(index_uni(1), nil_index_list()), l[(1 - 1)],
          "assigning variable l0");
      } else {
        current_statement__ = 66;
        assign(l0, nil_index_list(), rep_vector(0, N),
          "assigning variable l0");
      }
      current_statement__ = 77;
      if (logical_gt(LEVEL_CALC_METHOD, 0)) {
        current_statement__ = 69;
        movingSum = (y[(1 - 1)] - r[(1 - 1)]);
        current_statement__ = 71;
        for (int t = 2; t <= SEASONALITY2; ++t) {
          current_statement__ = 70;
          movingSum = ((movingSum + y[(t - 1)]) - r[(t - 1)]);}
        current_statement__ = 72;
        newLevelP = (movingSum / SEASONALITY2);
        current_statement__ = 75;
        if (logical_eq(LEVEL_CALC_METHOD, 2)) {
          current_statement__ = 74;
          for (int t = 1; t <= SEASONALITY2; ++t) {
            current_statement__ = 73;
            assign(l, cons_list(index_uni(t), nil_index_list()), newLevelP,
              "assigning variable l");}
        } 
      } 
      current_statement__ = 120;
      for (int t = 2; t <= N; ++t) {
        current_statement__ = 79;
        if ((primitive_value(logical_gt(LEVEL_CALC_METHOD, 0)) &&
            primitive_value(logical_gt(t, SEASONALITY2)))) {
          current_statement__ = 78;
          movingSum = ((movingSum + (y[(t - 1)] - r[(t - 1)])) -
                        (y[((t - SEASONALITY2) - 1)] -
                          r[((t - SEASONALITY2) - 1)]));
        } 
        current_statement__ = 88;
        if (logical_eq(SEASONALITY_TYPE, 0)) {
          current_statement__ = 84;
          assign(expVal, cons_list(index_uni(t), nil_index_list()),
            ((((l[((t - 1) - 1)] +
                 (coefTrend * pow(l[((t - 1) - 1)], powTrend))) * s[(t - 1)])
               * s2[(t - 1)]) + r[(t - 1)]), "assigning variable expVal");
          current_statement__ = 86;
          if (logical_neq(LEVEL_CALC_METHOD, 2)) {
            current_statement__ = 85;
            newLevelP = ((y[(t - 1)] - r[(t - 1)]) /
                          (s[(t - 1)] * s2[(t - 1)]));
          } 
        } else {
          current_statement__ = 80;
          assign(expVal, cons_list(index_uni(t), nil_index_list()),
            ((((l[((t - 1) - 1)] +
                 (coefTrend * pow(l[((t - 1) - 1)], powTrend))) +
                (s[(t - 1)] * pow(l[((t - 1) - 1)], powSeason))) +
               (s2[(t - 1)] * pow(l[((t - 1) - 1)], powSeason2))) +
              r[(t - 1)]), "assigning variable expVal");
          current_statement__ = 82;
          if (logical_neq(LEVEL_CALC_METHOD, 2)) {
            current_statement__ = 81;
            newLevelP = (((y[(t - 1)] - r[(t - 1)]) -
                           (s[(t - 1)] * pow(l[((t - 1) - 1)], powSeason))) -
                          (s2[(t - 1)] * pow(l[((t - 1) - 1)], powSeason2)));
          } 
        }
        current_statement__ = 98;
        if (logical_eq(LEVEL_CALC_METHOD, 0)) {
          current_statement__ = 97;
          assign(l, cons_list(index_uni(t), nil_index_list()),
            ((levSm * newLevelP) + ((1 - levSm) * l[((t - 1) - 1)])),
            "assigning variable l");
        } else {
          current_statement__ = 96;
          if ((primitive_value(logical_eq(LEVEL_CALC_METHOD, 2)) &&
              primitive_value(logical_gt(t, SEASONALITY)))) {
            current_statement__ = 95;
            assign(l, cons_list(index_uni(t), nil_index_list()),
              (((levSm * movingSum) / SEASONALITY2) +
                ((1 - levSm) * l[((t - 1) - 1)])), "assigning variable l");
          } else {
            current_statement__ = 94;
            if (logical_eq(LEVEL_CALC_METHOD, 3)) {
              current_statement__ = 89;
              assign(l0, cons_list(index_uni(t), nil_index_list()),
                ((levSm * newLevelP) + ((1 - levSm) * l0[((t - 1) - 1)])),
                "assigning variable l0");
              current_statement__ = 92;
              if (logical_lte(t, SEASONALITY2)) {
                current_statement__ = 91;
                assign(l, cons_list(index_uni(t), nil_index_list()),
                  l0[(t - 1)], "assigning variable l");
              } else {
                current_statement__ = 90;
                assign(l, cons_list(index_uni(t), nil_index_list()),
                  ((llevSm * l0[(t - 1)]) +
                    (((1 - llevSm) * movingSum) / SEASONALITY2)),
                  "assigning variable l");
              }
            } 
          }
        }
        current_statement__ = 105;
        if (logical_eq(SEASONALITY_TYPE, 0)) {
          current_statement__ = 102;
          seasonalityP = (((sSm * (y[(t - 1)] - r[(t - 1)])) /
                            (l[(t - 1)] * s2[(t - 1)])) +
                           ((1 - sSm) * s[(t - 1)]));
          current_statement__ = 103;
          seasonalityP2 = (((s2Sm * (y[(t - 1)] - r[(t - 1)])) /
                             (l[(t - 1)] * s[(t - 1)])) +
                            ((1 - s2Sm) * s2[(t - 1)]));
        } else {
          current_statement__ = 99;
          seasonalityP = (((sSm *
                             (((y[(t - 1)] - l[(t - 1)]) -
                                (s2[(t - 1)] * pow(l[(t - 1)], powSeason2)))
                               - r[(t - 1)])) / pow(l[(t - 1)], powSeason)) +
                           ((1 - sSm) * s[(t - 1)]));
          current_statement__ = 100;
          seasonalityP2 = (((s2Sm *
                              (((y[(t - 1)] - l[(t - 1)]) -
                                 (s[(t - 1)] * pow(l[(t - 1)], powSeason))) -
                                r[(t - 1)])) / pow(l[(t - 1)], powSeason2)) +
                            ((1 - s2Sm) * s2[(t - 1)]));
        }
        current_statement__ = 110;
        if (logical_gt(fractSeasonality, 0)) {
          current_statement__ = 107;
          assign(s,
            cons_list(index_uni(((t + SEASONALITY) + 1)), nil_index_list()),
            seasonalityP, "assigning variable s");
          current_statement__ = 108;
          assign(s,
            cons_list(index_uni((t + SEASONALITY)), nil_index_list()),
            ((fractSeasonality * s[((t + SEASONALITY) - 1)]) +
              ((1 - fractSeasonality) * seasonalityP)),
            "assigning variable s");
        } else {
          current_statement__ = 106;
          assign(s,
            cons_list(index_uni((t + SEASONALITY)), nil_index_list()),
            seasonalityP, "assigning variable s");
        }
        current_statement__ = 115;
        if (logical_gt(fractSeasonality2, 0)) {
          current_statement__ = 112;
          assign(s2,
            cons_list(index_uni(((t + SEASONALITY2) + 1)), nil_index_list()),
            seasonalityP2, "assigning variable s2");
          current_statement__ = 113;
          assign(s2,
            cons_list(index_uni((t + SEASONALITY2)), nil_index_list()),
            ((fractSeasonality2 * s2[((t + SEASONALITY2) - 1)]) +
              ((1 - fractSeasonality2) * seasonalityP2)),
            "assigning variable s2");
        } else {
          current_statement__ = 111;
          assign(s2,
            cons_list(index_uni((t + SEASONALITY2)), nil_index_list()),
            seasonalityP2, "assigning variable s2");
        }
        current_statement__ = 118;
        if (USE_SMOOTHED_ERROR) {
          current_statement__ = 117;
          assign(smoothedInnovSize,
            cons_list(index_uni(t), nil_index_list()),
            ((innovSm * stan::math::abs((y[(t - 1)] - expVal[(t - 1)]))) +
              ((1 - innovSm) * smoothedInnovSize[((t - 1) - 1)])),
            "assigning variable smoothedInnovSize");
        } else {
          current_statement__ = 116;
          assign(smoothedInnovSize,
            cons_list(index_uni(t), nil_index_list()), 1,
            "assigning variable smoothedInnovSize");
        }}
      current_statement__ = 19;
      current_statement__ = 19;
      check_greater_or_equal(function__, "powTrend", powTrend, MIN_POW_TREND);
      current_statement__ = 19;
      current_statement__ = 19;
      check_less_or_equal(function__, "powTrend", powTrend, MAX_POW_TREND);
      current_statement__ = 20;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 20;
        current_statement__ = 20;
        check_greater_or_equal(function__, "l[sym1__]", l[(sym1__ - 1)], 0);}
      current_statement__ = 21;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 21;
        current_statement__ = 21;
        check_greater_or_equal(function__, "l0[sym1__]", l0[(sym1__ - 1)], 0);
      }
      current_statement__ = 25;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 25;
        current_statement__ = 25;
        check_greater_or_equal(function__, "expVal[sym1__]",
                               expVal[(sym1__ - 1)], 0);}
      current_statement__ = 26;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 26;
        current_statement__ = 26;
        check_greater_or_equal(function__, "smoothedInnovSize[sym1__]",
                               smoothedInnovSize[(sym1__ - 1)], 0);}
      if (emit_transformed_parameters__) {
        vars__.emplace_back(powTrend);
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(l[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(l0[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= s_1dim__; ++sym1__) {
          vars__.emplace_back(s[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= s2_1dim__; ++sym1__) {
          vars__.emplace_back(s2[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(r[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(expVal[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(smoothedInnovSize[(sym1__ - 1)]);}
        vars__.emplace_back(seasonalityP);
        vars__.emplace_back(seasonalityP2);
        vars__.emplace_back(sumsu);
        vars__.emplace_back(newLevelP);
        vars__.emplace_back(movingSum);
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> regCoef;
      regCoef = Eigen::Matrix<double, -1, 1>(J);
      stan::math::fill(regCoef, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> regCoef_flat__;
        current_statement__ = 1;
        assign(regCoef_flat__, nil_index_list(), context__.vals_r("regCoef"),
          "assigning variable regCoef_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 1;
          assign(regCoef, cons_list(index_uni(sym1__), nil_index_list()),
            regCoef_flat__[(pos__ - 1)], "assigning variable regCoef");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      double regOffset;
      regOffset = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      regOffset = context__.vals_r("regOffset")[(1 - 1)];
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      nu = context__.vals_r("nu")[(1 - 1)];
      double nu_free__;
      nu_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      nu_free__ = stan::math::lub_free(nu, MIN_NU, MAX_NU);
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma = context__.vals_r("sigma")[(1 - 1)];
      double sigma_free__;
      sigma_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma_free__ = stan::math::lb_free(sigma, 0);
      double levSm;
      levSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      levSm = context__.vals_r("levSm")[(1 - 1)];
      double levSm_free__;
      levSm_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      levSm_free__ = stan::math::lub_free(levSm, 0, 1);
      double llevSm;
      llevSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      llevSm = context__.vals_r("llevSm")[(1 - 1)];
      double llevSm_free__;
      llevSm_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      llevSm_free__ = stan::math::lub_free(llevSm, 0, 1);
      double sSm;
      sSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      sSm = context__.vals_r("sSm")[(1 - 1)];
      double sSm_free__;
      sSm_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      sSm_free__ = stan::math::lub_free(sSm, 0, 1);
      double s2Sm;
      s2Sm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      s2Sm = context__.vals_r("s2Sm")[(1 - 1)];
      double s2Sm_free__;
      s2Sm_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      s2Sm_free__ = stan::math::lub_free(s2Sm, 0, 1);
      double powx;
      powx = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      powx = context__.vals_r("powx")[(1 - 1)];
      double powx_free__;
      powx_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      powx_free__ = stan::math::lub_free(powx, 0, 1);
      double powTrendBeta;
      powTrendBeta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 10;
      powTrendBeta = context__.vals_r("powTrendBeta")[(1 - 1)];
      double powTrendBeta_free__;
      powTrendBeta_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 10;
      powTrendBeta_free__ = stan::math::lub_free(powTrendBeta, 0, 1);
      double coefTrend;
      coefTrend = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 11;
      coefTrend = context__.vals_r("coefTrend")[(1 - 1)];
      double offsetSigma;
      offsetSigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 12;
      offsetSigma = context__.vals_r("offsetSigma")[(1 - 1)];
      double offsetSigma_free__;
      offsetSigma_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 12;
      offsetSigma_free__ = stan::math::lb_free(offsetSigma, MIN_SIGMA);
      double innovSm;
      innovSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 13;
      innovSm = context__.vals_r("innovSm")[(1 - 1)];
      double innovSm_free__;
      innovSm_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 13;
      innovSm_free__ = stan::math::lub_free(innovSm, 0, 1);
      double innovSizeInit;
      innovSizeInit = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 14;
      innovSizeInit = context__.vals_r("innovSizeInit")[(1 - 1)];
      double innovSizeInit_free__;
      innovSizeInit_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 14;
      innovSizeInit_free__ = stan::math::lb_free(innovSizeInit, 0);
      Eigen::Matrix<double, -1, 1> initS;
      initS = Eigen::Matrix<double, -1, 1>(SEASONALITY);
      stan::math::fill(initS, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> initS_flat__;
        current_statement__ = 15;
        assign(initS_flat__, nil_index_list(), context__.vals_r("initS"),
          "assigning variable initS_flat__");
        current_statement__ = 15;
        pos__ = 1;
        current_statement__ = 15;
        for (int sym1__ = 1; sym1__ <= SEASONALITY; ++sym1__) {
          current_statement__ = 15;
          assign(initS, cons_list(index_uni(sym1__), nil_index_list()),
            initS_flat__[(pos__ - 1)], "assigning variable initS");
          current_statement__ = 15;
          pos__ = (pos__ + 1);}
      }
      double powSeason;
      powSeason = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 16;
      powSeason = context__.vals_r("powSeason")[(1 - 1)];
      double powSeason_free__;
      powSeason_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 16;
      powSeason_free__ = stan::math::lub_free(powSeason, 0, 1);
      Eigen::Matrix<double, -1, 1> initS2;
      initS2 = Eigen::Matrix<double, -1, 1>(SEASONALITY2);
      stan::math::fill(initS2, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> initS2_flat__;
        current_statement__ = 17;
        assign(initS2_flat__, nil_index_list(), context__.vals_r("initS2"),
          "assigning variable initS2_flat__");
        current_statement__ = 17;
        pos__ = 1;
        current_statement__ = 17;
        for (int sym1__ = 1; sym1__ <= SEASONALITY2; ++sym1__) {
          current_statement__ = 17;
          assign(initS2, cons_list(index_uni(sym1__), nil_index_list()),
            initS2_flat__[(pos__ - 1)], "assigning variable initS2");
          current_statement__ = 17;
          pos__ = (pos__ + 1);}
      }
      double powSeason2;
      powSeason2 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 18;
      powSeason2 = context__.vals_r("powSeason2")[(1 - 1)];
      double powSeason2_free__;
      powSeason2_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 18;
      powSeason2_free__ = stan::math::lub_free(powSeason2, 0, 1);
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        vars__.emplace_back(regCoef[(sym1__ - 1)]);}
      vars__.emplace_back(regOffset);
      vars__.emplace_back(nu_free__);
      vars__.emplace_back(sigma_free__);
      vars__.emplace_back(levSm_free__);
      vars__.emplace_back(llevSm_free__);
      vars__.emplace_back(sSm_free__);
      vars__.emplace_back(s2Sm_free__);
      vars__.emplace_back(powx_free__);
      vars__.emplace_back(powTrendBeta_free__);
      vars__.emplace_back(coefTrend);
      vars__.emplace_back(offsetSigma_free__);
      vars__.emplace_back(innovSm_free__);
      vars__.emplace_back(innovSizeInit_free__);
      for (int sym1__ = 1; sym1__ <= SEASONALITY; ++sym1__) {
        vars__.emplace_back(initS[(sym1__ - 1)]);}
      vars__.emplace_back(powSeason_free__);
      for (int sym1__ = 1; sym1__ <= SEASONALITY2; ++sym1__) {
        vars__.emplace_back(initS2[(sym1__ - 1)]);}
      vars__.emplace_back(powSeason2_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("regCoef");
    names__.emplace_back("regOffset");
    names__.emplace_back("nu");
    names__.emplace_back("sigma");
    names__.emplace_back("levSm");
    names__.emplace_back("llevSm");
    names__.emplace_back("sSm");
    names__.emplace_back("s2Sm");
    names__.emplace_back("powx");
    names__.emplace_back("powTrendBeta");
    names__.emplace_back("coefTrend");
    names__.emplace_back("offsetSigma");
    names__.emplace_back("innovSm");
    names__.emplace_back("innovSizeInit");
    names__.emplace_back("initS");
    names__.emplace_back("powSeason");
    names__.emplace_back("initS2");
    names__.emplace_back("powSeason2");
    names__.emplace_back("powTrend");
    names__.emplace_back("l");
    names__.emplace_back("l0");
    names__.emplace_back("s");
    names__.emplace_back("s2");
    names__.emplace_back("r");
    names__.emplace_back("expVal");
    names__.emplace_back("smoothedInnovSize");
    names__.emplace_back("seasonalityP");
    names__.emplace_back("seasonalityP2");
    names__.emplace_back("sumsu");
    names__.emplace_back("newLevelP");
    names__.emplace_back("movingSum");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(J)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(SEASONALITY)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(SEASONALITY2)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(s_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(s2_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "regCoef" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "regOffset");
    param_names__.emplace_back(std::string() + "nu");
    param_names__.emplace_back(std::string() + "sigma");
    param_names__.emplace_back(std::string() + "levSm");
    param_names__.emplace_back(std::string() + "llevSm");
    param_names__.emplace_back(std::string() + "sSm");
    param_names__.emplace_back(std::string() + "s2Sm");
    param_names__.emplace_back(std::string() + "powx");
    param_names__.emplace_back(std::string() + "powTrendBeta");
    param_names__.emplace_back(std::string() + "coefTrend");
    param_names__.emplace_back(std::string() + "offsetSigma");
    param_names__.emplace_back(std::string() + "innovSm");
    param_names__.emplace_back(std::string() + "innovSizeInit");
    for (int sym1__ = 1; sym1__ <= SEASONALITY; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "initS" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "powSeason");
    for (int sym1__ = 1; sym1__ <= SEASONALITY2; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "initS2" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "powSeason2");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "powTrend");
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "l" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "l0" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= s_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "s" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= s2_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "s2" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "r" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "expVal" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "smoothedInnovSize" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "seasonalityP");
      param_names__.emplace_back(std::string() + "seasonalityP2");
      param_names__.emplace_back(std::string() + "sumsu");
      param_names__.emplace_back(std::string() + "newLevelP");
      param_names__.emplace_back(std::string() + "movingSum");
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "regCoef" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "regOffset");
    param_names__.emplace_back(std::string() + "nu");
    param_names__.emplace_back(std::string() + "sigma");
    param_names__.emplace_back(std::string() + "levSm");
    param_names__.emplace_back(std::string() + "llevSm");
    param_names__.emplace_back(std::string() + "sSm");
    param_names__.emplace_back(std::string() + "s2Sm");
    param_names__.emplace_back(std::string() + "powx");
    param_names__.emplace_back(std::string() + "powTrendBeta");
    param_names__.emplace_back(std::string() + "coefTrend");
    param_names__.emplace_back(std::string() + "offsetSigma");
    param_names__.emplace_back(std::string() + "innovSm");
    param_names__.emplace_back(std::string() + "innovSizeInit");
    for (int sym1__ = 1; sym1__ <= SEASONALITY; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "initS" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "powSeason");
    for (int sym1__ = 1; sym1__ <= SEASONALITY2; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "initS2" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "powSeason2");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "powTrend");
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "l" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "l0" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= s_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "s" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= s2_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "s2" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "r" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "expVal" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "smoothedInnovSize" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "seasonalityP");
      param_names__.emplace_back(std::string() + "seasonalityP2");
      param_names__.emplace_back(std::string() + "sumsu");
      param_names__.emplace_back(std::string() + "newLevelP");
      param_names__.emplace_back(std::string() + "movingSum");
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"regCoef\",\"type\":{\"name\":\"vector\",\"length\":" << J << "},\"block\":\"parameters\"},{\"name\":\"regOffset\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"levSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"llevSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"s2Sm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powx\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powTrendBeta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"coefTrend\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"offsetSigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"innovSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"innovSizeInit\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"initS\",\"type\":{\"name\":\"vector\",\"length\":" << SEASONALITY << "},\"block\":\"parameters\"},{\"name\":\"powSeason\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"initS2\",\"type\":{\"name\":\"vector\",\"length\":" << SEASONALITY2 << "},\"block\":\"parameters\"},{\"name\":\"powSeason2\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powTrend\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"l\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"l0\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"s\",\"type\":{\"name\":\"vector\",\"length\":" << s_1dim__ << "},\"block\":\"transformed_parameters\"},{\"name\":\"s2\",\"type\":{\"name\":\"vector\",\"length\":" << s2_1dim__ << "},\"block\":\"transformed_parameters\"},{\"name\":\"r\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"expVal\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"smoothedInnovSize\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"seasonalityP\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"seasonalityP2\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"sumsu\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"newLevelP\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"movingSum\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"regCoef\",\"type\":{\"name\":\"vector\",\"length\":" << J << "},\"block\":\"parameters\"},{\"name\":\"regOffset\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"levSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"llevSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"s2Sm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powx\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powTrendBeta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"coefTrend\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"offsetSigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"innovSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"innovSizeInit\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"initS\",\"type\":{\"name\":\"vector\",\"length\":" << SEASONALITY << "},\"block\":\"parameters\"},{\"name\":\"powSeason\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"initS2\",\"type\":{\"name\":\"vector\",\"length\":" << SEASONALITY2 << "},\"block\":\"parameters\"},{\"name\":\"powSeason2\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powTrend\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"l\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"l0\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"s\",\"type\":{\"name\":\"vector\",\"length\":" << s_1dim__ << "},\"block\":\"transformed_parameters\"},{\"name\":\"s2\",\"type\":{\"name\":\"vector\",\"length\":" << s2_1dim__ << "},\"block\":\"transformed_parameters\"},{\"name\":\"r\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"expVal\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"smoothedInnovSize\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"seasonalityP\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"seasonalityP2\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"sumsu\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"newLevelP\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"movingSum\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_S2GT_namespace::model_S2GT;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_S2GT_namespace::profiles__;
}
#endif
#endif
