% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbase.curvedist.R
\name{rbase.curvedist}
\alias{rbase.curvedist}
\title{Distance between Two Curves with Finite Difference Approximation}
\usage{
rbase.curvedist(curve1, curve2, t = NULL, type = c("intrinsic",
  "extrinsic"))
}
\arguments{
\item{curve1}{a S3 object of \code{riemdata} class, whose \code{$data} element is of length \eqn{N}.}

\item{curve2}{a S3 object of \code{riemdata} class, whose \code{$data} element is of length \eqn{N}.}

\item{t}{a length-\eqn{N} vector of locations. If \code{NULL} is given, it uses a equidistanct sequence from 1 to \eqn{N}.}

\item{type}{type of Riemannian distance (\code{"intrinsic"} or \code{"extrnisic"}).}
}
\value{
computed distance.
}
\description{
Suppose we have to two curves \eqn{f,g:I\subset \mathbf{R} \rightarrow \mathcal{M}} evaluated at finite locations \eqn{t_0 \le \ldots \le t_N},
\code{rbase.curvedist} computes distance between two curves \eqn{f} and \eqn{g} using finite difference approximation with trapezoidal rule.
In order to induce no interpolation, two curves should be of same length.
}
\examples{
\dontrun{
### Generate two sets of 10 2-frames in R^4 : as grassmann points
ndata = 10
data1 = array(0,c(4,2,ndata))
data2 = array(0,c(4,2,ndata))
for (i in 1:ndata){
  tgt = matrix(rnorm(4*4),nrow=4)
  data1[,,i] = qr.Q(qr(tgt))[,1:2]
}
for (i in 1:ndata){
  tgt = matrix(rnorm(4*5, sd=2),nrow=4)
  data2[,,i] = qr.Q(qr(tgt))[,1:2]
}

gdata1 = riemfactory(data1, name="grassmann") # wrap as 'riemdata' class.
gdata2 = riemfactory(data2, name="grassmann")

rbase.curvedist(gdata1, gdata2)
}

}
