% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rgff.R
\name{get_features}
\alias{get_features}
\title{Analyses the feature type hierarchy of a GFF file}
\usage{
get_features(
  inFile,
  includeCounts = FALSE,
  outFormat = c("tree", "data.frame", "JSON"),
  fileType = c("AUTO", "GFF3", "GTF")
)
}
\arguments{
\item{inFile}{Path to the input GTF/GFF3 features  file}

\item{includeCounts}{Include number of occurrences of each feature and subfeature}

\item{outFormat}{Output format of the function. Available formats are: tree (DEFAULT), data.frame and JSON.}

\item{fileType}{Version of the input file (GTF/GFF3). Default AUTO: determined from the file name.}
}
\value{
Depending on the outFormat selected returns a feature tree (tree), a feature dependency table as data.frame (data.frame) or a feature dependency table as JSON object (JSON)
}
\description{
Based on the feature type hierarchy a GFF file, this function creates and returns
a feature tree or a feature dependency table.
}
\examples{
test_gff3<-system.file("extdata", "AthSmall.gff3", package="Rgff")
get_features(test_gff3)
}
