powerDemo <- function (n = 1, sd = 1, diff = 1, alpha = 0.05, xmin = -4, xmax = 4,colored=NULL) {
    par(mfrow = c(2, 1), oma = c(0, 0, 3.1, 0),mar=c(4,3,3,0),cex=0.75)
    PDenvir <- new.env()
    PDenvir$n <- tclVar(as.integer(n))
    PDenvir$sd <- tclVar(as.numeric(sd))
    PDenvir$diff <- tclVar(as.numeric(diff))
    PDenvir$alpha <- tclVar(as.numeric(alpha))
    PDenvir$xmin <- as.numeric(xmin)
    PDenvir$xmax <- as.numeric(xmax)
    refresh <- function(...){
      n <- as.numeric(tclvalue(PDenvir$n))
      sd <- as.numeric(tclvalue(PDenvir$sd))
      diff <- as.numeric(tclvalue(PDenvir$diff))
      alpha <- as.numeric(tclvalue(PDenvir$alpha))
      se <- sd/sqrt(n)
      x <- seq(PDenvir$xmin, PDenvir$xmax, length.out = 100)
      m <- diff*sqrt(n/2)/sd
      plot(x, dnorm(x, 0, 1), type = "n", ylab = "", main = "Null Distribution",xlim=c(PDenvir$xmin,PDenvir$xmax))
      r <- qnorm(1 - alpha, 0, 1)
      polygon(c(r, r, x[x > r]), c(0, dnorm(c(r, x[x > r]), 0, 1)), col = "pink")
      abline(h = 0)
      lines(x, dnorm(x, 0, 1), col = "red")
      abline(v = r)
      axis(1, at = r, line = -0.75, cex = 0.7)
      legend("topright", xjust = 1, bty = "n", fill = "pink", legend = expression(alpha))
      plot(x, dnorm(x, m, 1), type = "n", ylab = "", main = "Alternative Distribution",xlim=c(PDenvir$xmin,PDenvir$xmax))
      polygon(c(r, r, x[x > r], max(x)), c(0, dnorm(c(r, x[x > r]), m, 1), 0), col = "lightblue")
      abline(h = 0)
      lines(x, dnorm(x, m, 1), col = "blue")
      abline(v = r)
      axis(1, at = r, line = -0.75, cex = 0.7)
      legend("topright", xjust = 1, bty = "n", fill = "lightblue", legend = "Power")
      ind = match(c("se","z","power","n","sd","diff","alpha"),colored,nomatch=0)
      ind = ind+1
      ind[3]=4
      mtext(c(paste("se =", signif(se, 3)),paste("z* =", signif(r,3)),paste("power =", round(1 - pnorm(r, m, 1), 3))), col=ind[1:3], outer = TRUE, line = 2, cex = 1,at=c(0.35,0.5,0.7))
      mtext(c(paste("n =", n),paste("sd =", sd),paste("diff =", diff),paste("alpha =", alpha)),col=ind[4:7], outer = TRUE, line = 0, cex = 1,at=c(0.35,0.45,0.55,0.7))
      invisible(1 - pnorm(r, diff, se))
    }
    m <- tktoplevel(width=200)
    tkwm.title(m,"Power Demo")
    nScale <- tkscale(m,command=refresh,digits=0,from=1,to=1000,variable=PDenvir$n,label='n',orient='horiz',length=200)
    sdScale <- tkscale(m,command=refresh,digits=0,from=0.05,to=20,resolution=0.05,variable=PDenvir$sd,label='sd',orient='horiz',length=200)
    diffScale <- tkscale(m,command=refresh,digits=0,from=0.05,to=10,resolution=0.05,variable=PDenvir$diff,label='diff',orient='horiz',length=200)
    alphaScale <- tkscale(m,command=refresh,digits=0,from=0.01,to=1,resolution=0.01,variable=PDenvir$alpha,label='alpha',orient='horiz',length=200)
    tkgrid(nScale)
    tkgrid(sdScale)
    tkgrid(diffScale)
    tkgrid(alphaScale)
  }
