% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setLibPaths.R
\name{setLibPaths}
\alias{setLibPaths}
\title{Set \code{.libPaths}}
\usage{
setLibPaths(libPaths, standAlone = TRUE)
}
\arguments{
\item{libPaths}{A new path to append to, or replace all existing user
components of \code{.libPath()}}

\item{standAlone}{Logical. If \code{TRUE}, all packages will be installed to and loaded from
                  the \code{libPaths} only. If \code{FALSE}, then \code{libPath} will
                  be prepended to \code{.libPaths()} during the \code{Require} call,
                  resulting in shared packages, i.e.,
                  it will include the user's default package folder(s).
                  This can be create dramatically faster
installs if the user has a substantial number of the packages already in
their personal library. Default \code{FALSE} to minimize package installing.}
}
\value{
The main point of this function is to set \code{.libPaths()}, which
will be changed as a side effect of this function.
As when setting \code{options}, this will return the previous state of
\code{.libPaths()} allowing the user to reset easily.
}
\description{
This will set the \code{.libPaths()} by either adding a new path to
it if \code{standAlone = FALSE}, or will concatenate
\code{c(libPath, tail(.libPaths(), 1))} if \code{standAlone = TRUE}.
}
\details{
This code was taken from \url{https://milesmcbain.xyz/hacking-r-library-paths/}.
A different, likely non-approved by CRAN approach that also works is here:
\url{https://stackoverflow.com/a/36873741/3890027}.
}
\examples{
\dontrun{
orig <- setLibPaths("~/newProjectLib") # will only have 2 paths,
                                       # this and the last one in .libPaths()
.libPaths() # see the 2 paths
setLibPaths(orig) # reset
.libPaths() # see the 2 original paths back

# will have 2 or more paths
setLibPaths("~/newProjectLib", standAlone = FALSE) # will have 2 or more paths

}
}
