/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml;

import com.topologi.diffx.xml.XMLSerializable;
import com.topologi.diffx.xml.XMLWritable;
import com.topologi.diffx.xml.XMLWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLSerializer {
    private static final DateFormat DF = new SimpleDateFormat("dd/MM/yyyy");
    private final XMLWriter xml;

    public XMLSerializer(XMLWriter xml) {
        this.xml = xml;
    }

    public XMLWriter getXML() {
        return this.xml;
    }

    public void serialize(Object o, String name) throws IOException {
        if (o != null) {
            if (name.lastIndexOf(46) != -1) {
                name = name.substring(name.lastIndexOf(46) + 1);
            }
            if (name.lastIndexOf(36) != -1) {
                name = name.substring(name.lastIndexOf(36) + 1);
            }
            name = name.toLowerCase();
            if (o instanceof Number) {
                this.xml.openElement(name, false);
                this.xml.writeText(o.toString());
                this.xml.closeElement();
            } else if (o instanceof String) {
                this.xml.openElement(name, false);
                this.xml.writeText(o.toString());
                this.xml.closeElement();
            } else if (o instanceof Character) {
                this.xml.openElement(name, false);
                this.xml.writeText(((Character)o).charValue());
                this.xml.closeElement();
            } else if (o instanceof Boolean) {
                this.xml.openElement(name, false);
                this.xml.writeText(o.toString());
                this.xml.closeElement();
            } else if (o instanceof Date) {
                this.xml.openElement(name, false);
                this.xml.writeText(DF.format((Date)o));
                this.xml.closeElement();
            } else if (o instanceof Collection) {
                this.xml.openElement(name, ((Collection)o).size() != 0);
                this.serializeCollection((Collection)o);
                this.xml.closeElement();
            } else if (o instanceof Hashtable) {
                this.xml.openElement(name, ((Hashtable)o).size() != 0);
                this.serializeHashtable((Hashtable)o);
                this.xml.closeElement();
            } else {
                this.xml.openElement(name, true);
                this.serializeObject(o);
                this.xml.closeElement();
            }
        }
    }

    public void serializeCollection(Collection<?> c) throws IOException {
        for (Object o : c) {
            this.serialize(o, o.getClass().getName());
        }
    }

    public void serializeHashtable(Hashtable<?, ?> h) throws IOException {
        this.xml.openElement("map", !h.isEmpty());
        Enumeration<?> e = h.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = h.get(key);
            this.xml.openElement("element");
            this.xml.openElement("key");
            this.serialize(key, "key");
            this.xml.closeElement();
            this.xml.openElement("value");
            this.serialize(value, "value");
            this.xml.closeElement();
            this.xml.closeElement();
        }
        this.xml.closeElement();
    }

    public void serializeObject(Object o) throws IOException {
        if (o instanceof XMLSerializable) {
            try {
                Method[] meth;
                Object[] args = new Object[]{};
                Class<?> cls = o.getClass();
                for (Method element : meth = cls.getMethods()) {
                    String methodName = element.getName();
                    if (!methodName.startsWith("get") || "getClass".equals(methodName)) continue;
                    Object retObj = element.invoke(o, args);
                    String attribute = methodName.substring(3).toLowerCase();
                    this.serialize(retObj, attribute);
                }
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.getTargetException().printStackTrace();
            }
        } else if (o instanceof XMLWritable) {
            ((XMLWritable)o).toXML(this.xml);
        }
    }
}

