/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.text;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Vector;

import org.docx4j.openpackaging.parts.WordprocessingML.FootnotesPart;
import org.docx4j.wml.CTFootnotes;
import org.docx4j.wml.CTFtnEdn;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.R.FootnoteRef;
import org.lysis.reporters.formats.TextProperties;
import org.lysis.reporters.tools.DOCX4R;
import org.lysis.reporters.tools.Debug;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;

public class FootNote extends DocComponent implements HTML4R, DOCX4R{
	
	private LinkedHashMap<Integer, ParagraphSet> parList;
	private int footnoteid;
	private TextProperties textProperties;
	
	public FootNote( TextProperties textProp ){
		super();
		textProperties = textProp;
		parList = new LinkedHashMap<Integer, ParagraphSet>();
		footnoteid = -1;
	}
	public TextProperties getTextProperties(){
		return textProperties;
	}
	
	public int getFootnoteID(){
		return footnoteid;
	}	
	
	public void addParagraph ( ParagraphSet par ){
		parList.put(size(), par);
	}
	public void addParagraph ( RScript par ){
		parList.put(size(), par);
	}
	
	public int size(){
		return parList.size() ;
	}
	
	public String toString(){
		String out = "";
		if( size() > 0 )
			for(int i = 0 ; i < size() ; i++ ){
				out += parList.get(i).toString() ;
			}
		return out;
	}


	@Override
	public String getHTML() {
		if( size() < 1 ) return "";
		String out = "";
		
		if( size() > 0 ){
			for(int i = 0 ; i < size() ; i++ ){
				parList.get(i).setHTMLReference(list_id, counters, numbDefinition);
				out += parList.get(i).getHTML();
			}
		}
		
		return out;
	}

	
	public boolean validateDOCXComponent(){
		if( docx_mlp == null ) {
			return false;
		}
		return true;
	}

	private void addFootnoteDefinition( Vector<P> pars ) throws Exception{
		
		if( Debug.debug_list ) System.err.println("addFootnoteDefinition" );
		CTFootnotes footnotes;
		
		try{
			footnotes = getDOCXMLPackage().getMainDocumentPart().getFootnotesPart().getJaxbElement();
		} catch( Exception e ){
			footnotes = new CTFootnotes();
		}
		FootnotesPart footnotespart ;
		footnotespart = new FootnotesPart();
		
		CTFtnEdn fotterEndNote = new CTFtnEdn();
		fotterEndNote.getContent().addAll(pars);
		
		footnoteid = footnotes.getFootnote().size()+1;
		fotterEndNote.setId(BigInteger.valueOf( footnoteid ));
		footnotes.getFootnote().add(fotterEndNote );

		footnotespart.setJaxbElement( footnotes );
		getDOCXMLPackage().getMainDocumentPart().addTargetPart(footnotespart);
	}
	

	
	public Vector<P> get_flextable_docx() throws Exception{
		Vector<P> out = new Vector<P>();

		if( !validateDOCXComponent() ) throw new Exception("class Footnote: elements need to be set...");

		if( size() > 0 ){
			for(int i = 0 ; i < size() ; i++ ){
				parList.get(i).getParProperties().setOrderedNumid(ordered_num_id);
				parList.get(i).setNumberingDefinitionsPart(ndp);
				parList.get(i).setOrderedNumID(ordered_num_id);
				parList.get(i).setUnorderedNumID(unordered_num_id);
				parList.get(i).setDOCXMLPackage(getDOCXMLPackage());
				Vector<P> temp = parList.get(i).get_flextable_docx();
				if( i == 0 ){
					FootnoteRef ff = new FootnoteRef();
					ObjectFactory of = new ObjectFactory();
					R run = new R();
					run.setRPr(textProperties.get_docx_pr());
					run.getContent().add(of.createRFootnoteRef(ff));
					temp.get(0).getContent().add(0, run);
				}
				out.addAll( temp );
			}
		}
		addFootnoteDefinition( out );
		return out;
	}
	
	@Override
	public String getCSS() {
		return null ;
	}

	@Override
	public String getJS() {
		return null;
	}

	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}





}
