% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPlot.R
\name{addPlot}
\alias{addPlot}
\alias{addPlot.bsdoc}
\alias{addPlot.docx}
\alias{addPlot.pptx}
\title{Add a plot into a document object}
\usage{
addPlot(doc, fun, pointsize = 12, vector.graphic = F, ...)

\method{addPlot}{docx}(doc, fun, pointsize = getOption("ReporteRs-fontsize"),
  vector.graphic = FALSE, width = 6, height = 6,
  fontname = getOption("ReporteRs-default-font"),
  fontname_serif = "Times New Roman", fontname_sans = "Calibri",
  fontname_mono = "Courier New", fontname_symbol = "Symbol",
  editable = TRUE, bookmark, par.properties = parProperties(text.align =
  "center", padding = 5), bg = "transparent", ...)

\method{addPlot}{pptx}(doc, fun, pointsize = 11, vector.graphic = TRUE,
  fontname = getOption("ReporteRs-default-font"),
  fontname_serif = "Times New Roman", fontname_sans = "Calibri",
  fontname_mono = "Courier New", fontname_symbol = "Symbol",
  editable = TRUE, offx, offy, width, height, bg = "transparent", ...)

\method{addPlot}{bsdoc}(doc, fun, pointsize = getOption("ReporteRs-fontsize"),
  vector.graphic = T, width = 6, height = 6,
  fontname = getOption("ReporteRs-default-font"),
  fontname_serif = "Times New Roman", fontname_sans = "Calibri",
  fontname_mono = "Courier New", fontname_symbol = "Symbol",
  tooltip_extra_css, hover_css, par.properties = parCenter(padding = 5),
  bg = "transparent", ggiraph = FALSE, ...)
}
\arguments{
\item{doc}{document object}

\item{fun}{plot function. The function will be executed to produce graphics.
For \code{grid} or \code{lattice} or \code{ggplot} object, the function
should just be \code{print} and an extra argument \code{x} should specify the object
to plot. For traditionnal plots, the function should contain plot instructions. See examples.}

\item{pointsize}{the default pointsize of plotted text in pixels, default to 12 pixels.}

\item{vector.graphic}{logical scalar, if TRUE, vector graphics are
produced instead, PNG images if FALSE.}

\item{...}{further arguments passed to or from other methods. See details.}

\item{width}{plot width in inches (default value is 6).}

\item{height}{plot height in inches (default value is 6).}

\item{fontname}{deprecated. the default font family to use, default to getOption("ReporteRs-default-font").}

\item{fontname_serif, fontname_sans, fontname_mono, fontname_symbol}{font
names for font faces. Use fonts available on operating system.}

\item{editable}{logical value - if TRUE vector graphics elements (points, text, etc.) are editable.}

\item{bookmark}{id of the Word bookmark to replace by the plot. optional.

\code{bookmark} is a character vector specifying bookmark id to replace by the plot(s).\cr
      If provided, plot(s) will replace the paragraph that contains the bookmark. See \code{\link{bookmark}}.\cr
      If not provided, plot(s) will be added at the end of the document.}

\item{par.properties}{paragraph formatting properties of the paragraph that contains plot(s).
An object of class \code{\link{parProperties}}}

\item{bg}{the initial background colour.}

\item{offx, offy}{optional. x and y position of the shape (left top position of the bounding box) in inches. See details.}

\item{tooltip_extra_css}{extra css (added to \code{position: absolute;pointer-events: none;})
used to customize tooltip area. Only used when \code{ggiraph} is TRUE.}

\item{hover_css}{css to apply when mouse is hover and element with a
data-id attribute. Only used when \code{ggiraph} is TRUE.}

\item{ggiraph}{boolean must be TRUE if graphic is made with package \code{ggiraph}.}
}
\value{
a document object
}
\description{
Add a plot into a document object
}
\details{
Plot parameters are specified with the \code{...} argument.
However, the most convenient usage is to wrap the plot code
into a function whose parameters will be specified as '...'.

If you want to add ggplot2 or lattice plot, use \code{print} function.

\code{vector.graphic}: SVG will be produced for \code{bsdoc} objects
and DrawingML instructions for \code{docx} and \code{pptx} objects.
Don't use vector graphics if document is a docx and MS Word version
used to open the document is 2007.

When document is a \code{pptx} object, two positioning methods are available.

If arguments offx, offy, width, height are missing, position and dimensions
will be defined by the width and height of the next available shape of the slide. This
dimensions can be defined in the layout of the PowerPoint template used to create
the \code{pptx} object.

If arguments offx, offy, width, height are provided, they become position and
dimensions of the new shape.

When document is a \code{bsdoc} object, ggplot2 objects made with ggiraph
can be integrated. It will require to set \code{ggiraph} to TRUE
and to add d3.js script in the bsdoc before adding ggiraph object.
See example below.
}
\examples{

is_sunos <- tolower(Sys.info()[["sysname"]]) == "sunos"

options( "ReporteRs-fontsize" = 11 )


# plot example for docx -----
doc = docx( )
doc = addPlot( doc, fun = function() barplot( 1:6, col = 2:7),
  vector.graphic = TRUE, width = 5, height = 7,
  par.properties = parProperties(text.align = "center")
  )
writeDoc( doc, file = "ex_plot.docx" )



# plot example for pptx -----

doc = pptx( )
doc = addSlide( doc, slide.layout = "Title and Content" )

doc = addPlot( doc, fun = function() barplot( 1:6, col = 2:7),
  vector.graphic = TRUE, width = 5, height = 4 )
if( !is_sunos ){
  doc = addPlot( doc,
    fun = function() barplot( 1:6, col = 2:7),
    vector.graphic = FALSE,
    offx = 7, offy = 0,
    width = 3, height = 2
    )
}

writeDoc( doc, file = "ex_plot.pptx" )



# plot example for bsdoc -----

doc = bsdoc( )

doc = addPlot( doc, fun = function() barplot( 1:6, col = 2:7),
  vector.graphic = TRUE, width = 5, height = 7,
  par.properties = parProperties(text.align = "left")
  )

writeDoc( doc, file = "ex_plot/example.html" )

\dontrun{
if(require(ggiraph)){
gg_p <- ggplot(iris, aes(x = Sepal.Length, y = Sepal.Width,
    tooltip = Species)) +
  geom_point_interactive(size = 3)

doc <- bsdoc()
download.file("https://cdnjs.cloudflare.com/ajax/libs/d3/3.5.16/d3.min.js",
  destfile = "d3.min.js")
doc <- addJavascript(doc = doc, file = "d3.min.js" )
unlink("d3.min.js")
doc <- addPlot(doc, fun = function() print(gg_p), ggiraph = TRUE)

writeDoc(doc, "ggiraph/index.html")
}
}

}
\seealso{
\code{\link{docx}}, \code{\link{pptx}}, \code{\link{bsdoc}}
}

