/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.tools;

import java.math.BigInteger;
import java.util.Vector;
import javax.xml.bind.JAXBElement;
import org.docx4j.dml.CTPoint2D;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.dml.CTTransform2D;
import org.docx4j.dml.ObjectFactory;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.lysis.reporters.docs.docx4R;
import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.lists.NumberingDefinition;
import org.lysis.reporters.tools.Debug;
import org.lysis.reporters.tools.EMU;

public class DocComponent {
    protected boolean hasBookmark = false;
    private JAXBElement<CTBookmark> bmStart;
    private JAXBElement<CTMarkupRange> bmEnd;
    protected PresentationMLPackage pptx_mlp = null;
    protected SlidePart slidePart = null;
    protected WordprocessingMLPackage docx_mlp = null;
    protected NumberingDefinitionsPart ndp;
    protected long ordered_num_id;
    protected long unordered_num_id;
    private long cx = -1L;
    private long cy = -1L;
    private long offx = -1L;
    private long offy = -1L;
    private ParProperties parProp = null;
    private PPr inherited_ppr = null;
    protected long unique_id = -1L;
    protected long shape_id = -1L;
    protected long list_id = -1L;
    protected NumberingDefinition numbDefinition;
    protected Vector<String> counters;

    public long getCx() {
        return this.cx;
    }

    public long getCy() {
        return this.cy;
    }

    public long getOffx() {
        return this.offx;
    }

    public long getOffy() {
        return this.offy;
    }

    public boolean validatePPTXComponent() {
        if (this.offx < 0L) {
            return false;
        }
        if (this.cx < 0L) {
            return false;
        }
        if (this.offy < 0L) {
            return false;
        }
        if (this.cy < 0L) {
            return false;
        }
        if (this.unique_id < 0L) {
            return false;
        }
        if (this.shape_id < 0L) {
            return false;
        }
        if (this.pptx_mlp == null) {
            return false;
        }
        return this.slidePart != null;
    }

    public boolean validateDOCXComponent() {
        if (this.unique_id < 0L) {
            if (Debug.debug) {
                System.err.println("unique_id is missing");
            }
            return false;
        }
        if (this.docx_mlp == null) {
            if (Debug.debug) {
                System.err.println("docx_mlp is missing");
            }
            return false;
        }
        if (this.inherited_ppr == null && this.parProp == null) {
            if (Debug.debug) {
                System.err.println("inherited_ppr == null && parProp == null is missing");
            }
            return false;
        }
        return true;
    }

    public void set_docx_bookmark(String bookmark, BigInteger bookmarkID) {
        this.hasBookmark = true;
        org.docx4j.wml.ObjectFactory factory = Context.getWmlObjectFactory();
        CTBookmark bm = new CTBookmark();
        bm.setId(bookmarkID);
        bm.setName(bookmark);
        this.bmStart = factory.createBodyBookmarkStart(bm);
        CTMarkupRange mr = factory.createCTMarkupRange();
        mr.setId(bookmarkID);
        this.bmEnd = factory.createBodyBookmarkEnd(mr);
    }

    public void addBookmark(P paragraph) {
        if (this.hasBookmark) {
            paragraph.getContent().add(this.bmStart);
        }
        if (this.hasBookmark) {
            paragraph.getContent().add(this.bmEnd);
        }
    }

    public void setExt(long w, long h) {
        this.cx = w;
        this.cy = h;
    }

    public void setExtCx(long w) {
        this.cx = w;
    }

    public void setExtCy(long h) {
        this.cy = h;
    }

    public void setOff(long x, long y) {
        this.offx = x;
        this.offy = y;
    }

    public void setOffx(long x) {
        this.offx = x;
    }

    public void setOffy(long y) {
        this.offy = y;
    }

    public void setOffAndExt(long x, long y, long w, long h) {
        this.cx = w;
        this.cy = h;
        this.offx = x;
        this.offy = y;
    }

    public void setHTMLReference(long lid, Vector<String> counters, NumberingDefinition nb) {
        this.list_id = lid;
        this.counters = counters;
        this.numbDefinition = nb;
    }

    public WordprocessingMLPackage getDOCXMLPackage() {
        return this.docx_mlp;
    }

    public void setNumberingDefinitionsPart(NumberingDefinitionsPart ndp) {
        this.ndp = ndp;
    }

    public void setOrderedNumID(long ordered_num_id) {
        this.ordered_num_id = ordered_num_id;
    }

    public void setUnorderedNumID(long unordered_num_id) {
        this.unordered_num_id = unordered_num_id;
    }

    public void setDOCXReference(NumberingDefinitionsPart ndp, long ordered_num_id, long unordered_num_id) {
        this.ndp = ndp;
        this.ordered_num_id = ordered_num_id;
        this.unordered_num_id = unordered_num_id;
    }

    public void setDOCXReference(docx4R doc) {
        this.docx_mlp = doc.getBaseDocument();
        this.ndp = doc.getNumberingDefinitionsPart();
        this.ordered_num_id = doc.getOrderedNumID();
        this.unordered_num_id = doc.getUnorderedNumID();
        this.getParProperties().setOrderedNumid(this.ordered_num_id);
        this.getParProperties().setUnorderedNumid(this.unordered_num_id);
    }

    public void setDOCXMLPackage(WordprocessingMLPackage mlpack) {
        this.docx_mlp = mlpack;
    }

    public void setPPTXMLPackage(PresentationMLPackage mlpack) {
        this.pptx_mlp = mlpack;
    }

    public void setPPTXSlidePart(SlidePart sp) {
        this.slidePart = sp;
    }

    public void setParProperties(ParProperties pp) {
        this.parProp = pp;
    }

    public void setPPr(PPr pp) {
        this.inherited_ppr = pp;
    }

    public void setPPr(String style) {
        P p = this.docx_mlp.getMainDocumentPart().createStyledParagraphOfText(style, "");
        this.inherited_ppr = p.getPPr();
    }

    public void setUID(long uid) {
        this.unique_id = uid;
    }

    public void setShapeID(long id) {
        this.shape_id = id;
    }

    public CTTransform2D getXfrm() {
        ObjectFactory dmlFactory = new ObjectFactory();
        CTTransform2D xfrm = dmlFactory.createCTTransform2D();
        CTPositiveSize2D ext = dmlFactory.createCTPositiveSize2D();
        ext.setCx(this.cx);
        ext.setCy(this.cy);
        xfrm.setExt(ext);
        CTPoint2D off = dmlFactory.createCTPoint2D();
        xfrm.setOff(off);
        off.setX(this.offx);
        off.setY(this.offy);
        return xfrm;
    }

    public PPr getPPr() {
        if (this.inherited_ppr == null) {
            return this.parProp.get_docx_pp();
        }
        return this.inherited_ppr;
    }

    public ParProperties getParProperties() {
        return this.parProp;
    }

    public double width() {
        return EMU.getInchFromEMU(this.cx);
    }

    public double height() {
        return EMU.getInchFromEMU(this.cy);
    }

    public void setXfrm(CTTransform2D xfrm) {
        this.offx = xfrm.getOff().getX();
        this.offy = xfrm.getOff().getY();
        this.cx = xfrm.getExt().getCx();
        this.cy = xfrm.getExt().getCy();
        if (Debug.debug) {
            System.err.println("setXfrm > offx " + this.offx + " offy " + this.offy + " cx " + this.cx + " cy " + this.cy);
        }
    }

    public long nextUniqueId() {
        return this.unique_id + 1L;
    }
}

