package org.lysis.markdown.tools;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Span {
	
	private String blockText;
	private LinkedList<int[]> italicMatches;
	private LinkedList<int[]> boldMatches;
	private LinkedList<int[]> singlebacktickMatches;
	private LinkedList<int[]> doublebacktickMatches;
	private LinkedList<int[]> inlineLinkMatches;
	private LinkedList<int[]> referenceLinkMatches;
	private LinkedList<int[]> inlineImageMatches;
	private LinkedList<int[]> referenceImageMatches;
	private LinkedList<int[]> footnoteMatches;

	public Span(String text){
		blockText = text;
	}
	
	static String anybutnoparenthesis = "([\\p{L}\\p{M}\\d\\s!\"#\\$%&'\\[\\]\\*_\\+,\\-\\.=\\:;\\<\\>\\?@`{}\\|~/]*)";
	static String anybutnoparenthesisnorquote = "([\\p{L}\\p{M}\\d\\s!#\\$%&\\[\\]\\*_\\+,\\-\\.=\\:;\\<\\>\\?@`{}\\|~/]*)";
	static String anybutnobracket = "([\\p{L}\\p{M}\\d\\s!\"#\\$%&'\\(\\)\\*_\\+,\\-\\.=\\:;\\<\\>\\?@`{}\\|~/]*)";
	static String paturl = "([ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789\\-_~\\:/\\?#\\[\\]@!\\$&'\\(\\)\\*\\+,;\\.=]*)";

	public static void main(String argc[ ]){
		
		String text = "This is a link to the [cr.an] (http://cran.r-project.org/sdf=sdf). **This paragraph** demonstrates note usage[^an-ote]. It also show an example of reference link like this one: [DaringFireball][1].";
		Span tt = new Span(text);
		tt.getEmphasisMatrix();
		
	}
	
	
	public boolean[] getEmphasisMatrix(){
				
		boolean[] out = new boolean[blockText.length()*9];

		flagFootnote();
		flagInlineImage();
		flagInlineLink();
		flagReferenceImage();
		flagReferenceLink();
		// these must be executed after the previous
		flagBold();
		flagItalic();
		flagCode();

		boolean[] islink = isInlineLink(  );
		boolean[] isreflink = isReferenceLink(  );
		boolean[] isinlineimage = isInlineImage();
		boolean[] isrefimage = isReferenceImage();
		boolean[] isfootnote = isFootnote();

		boolean[] isbold = isBold( );
		boolean[] isdoublebacktick = isDoubleBacktick(  );
		boolean[] issinglebacktick = isSingleBacktick( );
		boolean[] isitalic = isItalic(  );

//
//		System.out.print(" \t");
//		System.out.print("b\t");
//		System.out.print("`\t");
//		System.out.print("``\t");
//		System.out.print("i\t");
//		System.out.print("il\t");
//		System.out.print( "rl\t");
//		System.out.print( "ii\t");
//		System.out.print(  "ri\t");
//		System.out.print( "f\t");
//		System.out.println();

		for(int n = 0 ; n < blockText.length() ; n++ ){
			
//			System.out.print(blockText.charAt(n) + "\t");
//			System.out.print(isbold[n] + "\t");
//			System.out.print(issinglebacktick[n] + "\t");
//			System.out.print(isdoublebacktick[n] + "\t");
//			System.out.print(isitalic[n] + "\t");
//			System.out.print(islink[n] + "\t");
//			System.out.print(isreflink[n] + "\t");
//			System.out.print(isinlineimage[n] + "\t");
//			System.out.print(isrefimage[n] + "\t");
//			System.out.print(isfootnote[n] + "\t");
//			System.out.println();
			
			out[n] = isbold[n];
			out[(1*blockText.length()) + n] = issinglebacktick[n];
			out[(2*blockText.length()) + n] = isdoublebacktick[n];
			out[(3*blockText.length()) + n] = isitalic[n];
			out[(4*blockText.length()) + n] = islink[n];
			out[(5*blockText.length()) + n] = isreflink[n];
			out[(6*blockText.length()) + n] = isinlineimage[n];
			out[(7*blockText.length()) + n] = isrefimage[n];
			out[(8*blockText.length()) + n] = isfootnote[n];
		}
		return out;
	}
	
	private String protectSpecialSpan(){
		StringBuilder text = new StringBuilder(blockText);
		char white = ' ';
		for( int i = 0 ; i < inlineLinkMatches.size() ; i++ ){
			for(int w = inlineLinkMatches.get(i)[0] ; 
					w <= inlineLinkMatches.get(i)[1] ; w++){
				text.setCharAt(w, white);
			}
		}
		for( int i = 0 ; i < inlineImageMatches.size() ; i++ ){
			for(int w = inlineImageMatches.get(i)[0] ; 
					w <= inlineImageMatches.get(i)[1] ; w++){
				text.setCharAt(w, white);
			}
		}
		for( int i = 0 ; i < referenceImageMatches.size() ; i++ ){
			for(int w = referenceImageMatches.get(i)[0] ; 
					w <= referenceImageMatches.get(i)[1] ; w++){
				text.setCharAt(w, white);
			}
		}
		for( int i = 0 ; i < referenceLinkMatches.size() ; i++ ){
			for(int w = referenceLinkMatches.get(i)[0] ; 
					w <= referenceLinkMatches.get(i)[1] ; w++){
				text.setCharAt(w, white);
			}
		}
		return text.toString();
		
	}
	
	private void flagItalic(){
		Pattern pattern;
		Matcher matcher;
		italicMatches = new LinkedList<int[]>();
		
		pattern = Pattern.compile("(\\*|_)(.+?)\\1");
		String text = protectSpecialSpan();
		text = text.replaceAll("(\\*\\*|__)", "  ");
		
		matcher = pattern.matcher( text );
		while (matcher.find()) {
			int out[] = {matcher.start(), matcher.end()-1};
			italicMatches.add(out);
		}
	}


	
	private boolean[] isItalic(){

		boolean[] isPositiveMatch = new boolean[blockText.length()];
		for(int n = 0 ; n < blockText.length() ; n++ ){
			isPositiveMatch[n] = false;
			}
		for( int i = 0 ; i < italicMatches.size() ; i++ ){
			for(int w = italicMatches.get(i)[0] ; 
					w <= italicMatches.get(i)[1] ; w++){
				isPositiveMatch[w] = true;
			}
		}
		
		return isPositiveMatch;
	}


	private void flagBold(){
		Pattern pattern;
		Matcher matcher;
		boldMatches = new LinkedList<int[]>();
		
		pattern = Pattern.compile("(\\*\\*|__)(.+?[*_]*)\\1");
		String text = protectSpecialSpan();
		matcher = pattern.matcher( text );
		while (matcher.find()) {
			int out[] = {matcher.start(), matcher.end()-1};
			boldMatches.add(out);
		}
	}
	
	private boolean[] isBold(  ){

		boolean[] isPositiveMatch = new boolean[blockText.length()];
		for(int n = 0 ; n < blockText.length() ; n++ ){
			isPositiveMatch[n] = false;
		}
		
		for( int i = 0 ; i < boldMatches.size() ; i++ ){
			for(int w = boldMatches.get(i)[0] ; 
					w <= boldMatches.get(i)[1] ; w++){
				isPositiveMatch[w] = true;
			}
		}

		return isPositiveMatch;
	}

	private void flagCode(){
		Pattern pattern;
		Matcher matcher;
		singlebacktickMatches = new LinkedList<int[]>();
		doublebacktickMatches = new LinkedList<int[]>();
		String text = protectSpecialSpan();

		pattern = Pattern.compile("(`)(.+?)\\1");
		matcher = pattern.matcher( text );
		while (matcher.find()) {
			int out[] = {matcher.start(), matcher.end()-1};
			singlebacktickMatches.add(out);
		}
		pattern = Pattern.compile("(``)(.+?)\\1");
		matcher = pattern.matcher( text );
		while (matcher.find()) {
			int out[] = {matcher.start(), matcher.end()-1};
			doublebacktickMatches.add(out);
		}
	}
	
	private boolean[] isSingleBacktick( ){
		
		boolean[] isPositiveMatch = new boolean[blockText.length()];
		for(int n = 0 ; n < blockText.length() ; n++ ){
			isPositiveMatch[n] = false;
			}
		
		for( int i = 0 ; i < singlebacktickMatches.size() ; i++ ){
			for(int w = singlebacktickMatches.get(i)[0] ; 
					w <= singlebacktickMatches.get(i)[1] ; w++){
				isPositiveMatch[w] = true;
			}
		}
		return isPositiveMatch;
	}
	
	private boolean[] isDoubleBacktick( ){

		boolean[] isPositiveMatch = new boolean[blockText.length()];
		for(int n = 0 ; n < blockText.length() ; n++ ){
			isPositiveMatch[n] = false;
			}
		
		for( int i = 0 ; i < doublebacktickMatches.size() ; i++ ){
			for(int w = doublebacktickMatches.get(i)[0] ; 
					w <= doublebacktickMatches.get(i)[1] ; w++){
				isPositiveMatch[w] = true;
			}
		}
		return isPositiveMatch;
	}

	private void flagInlineLink(){
		Pattern pattern;
		Matcher matcher;
		inlineLinkMatches = new LinkedList<int[]>();
		
		pattern = Pattern.compile("(" + // all \\1
                "\\["+ anybutnobracket +"\\]" + // label \\2
                "\\s*" +
	                "\\(" +
			            "\\s*" +
		                paturl + // url \\3
		                "\\s*" +
			                "(" +
			                "(['\"])" + // quote \\5
			                anybutnoparenthesisnorquote + // tooltip \\6
			                "\\5" +
			                ")?" +
	                "\\)" +
                ")");
		matcher = pattern.matcher( blockText );
		while (matcher.find()) {
			int out[] = {matcher.start(), matcher.end()-1};
			inlineLinkMatches.add(out);
		}
	}
	private boolean[] isInlineLink(){

		boolean[] isPositiveMatch = new boolean[blockText.length()];
		for(int n = 0 ; n < blockText.length() ; n++ ){
			isPositiveMatch[n] = false;
			}
		for( int i = 0 ; i < inlineLinkMatches.size() ; i++ ){
			for(int w = inlineLinkMatches.get(i)[0] ; 
					w <= inlineLinkMatches.get(i)[1] ; w++){
				isPositiveMatch[w] = true;
			}
		}
		return isPositiveMatch;
	}
	
	private void flagReferenceLink(){
		Pattern pattern;
		Matcher matcher;
		referenceLinkMatches = new LinkedList<int[]>();
		
		pattern = Pattern.compile("(" + // all \\1
                "\\["+ anybutnobracket +"\\]" + // label \\2
                "\\s*" +
                "\\["+ anybutnobracket +"\\]" +
                ")");
		matcher = pattern.matcher( blockText );
		while (matcher.find()) {
			int out[] = {matcher.start(), matcher.end()-1};
			referenceLinkMatches.add(out);
		}
	}
	
	private boolean[] isReferenceLink(){
		boolean[] isPositiveMatch = new boolean[blockText.length()];
		for(int n = 0 ; n < blockText.length() ; n++ ){
			isPositiveMatch[n] = false;
			}
		
		for( int i = 0 ; i < referenceLinkMatches.size() ; i++ ){
			for(int w = referenceLinkMatches.get(i)[0] ; 
					w <= referenceLinkMatches.get(i)[1] ; w++){
				isPositiveMatch[w] = true;
			}
		}
		return isPositiveMatch;
	}
	
	private void flagInlineImage(){
		Pattern pattern;
		Matcher matcher;
		inlineImageMatches = new LinkedList<int[]>();
		
		pattern = Pattern.compile("(" + // all \\1
                "!\\["+ anybutnobracket +"\\]" + // label \\2
                "\\s*" +
	                "\\(" +
			            "\\s*" +
		                paturl + // url \\3
		                "\\s*" +
			                "(" +
			                "(['\"])" + // quote \\5
			                anybutnoparenthesisnorquote + // tooltip \\6
			                "\\5" +
			                ")?" +
	                "\\)" +
                ")");
		matcher = pattern.matcher( blockText );
		while (matcher.find()) {
			int out[] = {matcher.start(), matcher.end()-1};
			inlineImageMatches.add(out);
		}
	}
	private boolean[] isInlineImage( ){

		boolean[] isPositiveMatch = new boolean[blockText.length()];
		for(int n = 0 ; n < blockText.length() ; n++ ){
			isPositiveMatch[n] = false;
			}
		
		
		for( int i = 0 ; i < inlineImageMatches.size() ; i++ ){
			for(int w = inlineImageMatches.get(i)[0] ; 
					w <= inlineImageMatches.get(i)[1] ; w++){
				isPositiveMatch[w] = true;
			}
		}
		return isPositiveMatch;
	}
	
	private void flagReferenceImage(){
		Pattern pattern;
		Matcher matcher;
		referenceImageMatches = new LinkedList<int[]>();
		
		pattern = Pattern.compile("(" + // all \\1
                "!\\["+ anybutnobracket +"\\]" + // label \\2
                "\\s*" +
                "\\["+ anybutnobracket +"\\]" +
                ")");
		matcher = pattern.matcher( blockText );
		while (matcher.find()) {
			int out[] = {matcher.start(), matcher.end()-1};
			referenceImageMatches.add(out);
		}
	}
	private boolean[] isReferenceImage( ){

		boolean[] isPositiveMatch = new boolean[blockText.length()];
		for(int n = 0 ; n < blockText.length() ; n++ ){
			isPositiveMatch[n] = false;
			}
		
		for( int i = 0 ; i < referenceImageMatches.size() ; i++ ){
			for(int w = referenceImageMatches.get(i)[0] ; 
					w <= referenceImageMatches.get(i)[1] ; w++){
				isPositiveMatch[w] = true;
			}
		}
		return isPositiveMatch;
	}
	
	private void flagFootnote(){
		Pattern pattern;
		Matcher matcher;
		footnoteMatches = new LinkedList<int[]>();
		
		pattern = Pattern.compile("(" + // all \\1
                "\\[\\^"+ anybutnobracket +"\\]" +
                ")");
		matcher = pattern.matcher( blockText );
		while (matcher.find()) {
			int out[] = {matcher.start(), matcher.end()-1};
			footnoteMatches.add(out);
		}
	}
	private boolean[] isFootnote( ){

		boolean[] isPositiveMatch = new boolean[blockText.length()];
		for(int n = 0 ; n < blockText.length() ; n++ ){
			isPositiveMatch[n] = false;
			}

		for( int i = 0 ; i < footnoteMatches.size() ; i++ ){
			for(int w = footnoteMatches.get(i)[0] ; 
					w <= footnoteMatches.get(i)[1] ; w++){
				isPositiveMatch[w] = true;
			}
		}
		return isPositiveMatch;
	}
	
}
