/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.texts;

import java.util.LinkedHashMap;
import java.util.Vector;
import org.docx4j.dml.CTTextBody;
import org.docx4j.dml.CTTextBodyProperties;
import org.docx4j.dml.CTTextListStyle;
import org.docx4j.dml.CTTextParagraph;
import org.docx4j.dml.CTTextParagraphProperties;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.lysis.reporters.html4r.elements.HTML4R;
import org.lysis.reporters.pptx4r.tools.Format;
import org.lysis.reporters.texts.ParProperties;
import org.lysis.reporters.texts.Paragraph;
import org.lysis.reporters.texts.TextProperties;

public class ParagraphsSection
implements HTML4R {
    private LinkedHashMap<Integer, Paragraph> parList = new LinkedHashMap();
    private int parIndex = 0;
    private ParProperties parProp;

    public ParagraphsSection(ParProperties parProp) {
        this.setParProperties(parProp);
    }

    public void addParagraph(Paragraph par) {
        ++this.parIndex;
        this.parList.put(this.parIndex, par);
    }

    public int size() {
        return this.parIndex;
    }

    public Paragraph get(int i) {
        return this.parList.get(i);
    }

    public Paragraph getLast() {
        return this.parList.get(this.parIndex);
    }

    public void setParProperties(ParProperties parProp) {
        this.parProp = parProp;
    }

    public void setTextProperties(TextProperties tp) {
        if (this.parIndex > 0) {
            int i = 1;
            while (i < this.parIndex + 1) {
                this.parList.get(i).setTextProperties(tp);
                ++i;
            }
        }
    }

    public String toString() {
        String out = "";
        if (this.parIndex > 0) {
            int i = 1;
            while (i < this.parIndex + 1) {
                out = String.valueOf(out) + this.parList.get(i).toString();
                ++i;
            }
        }
        return out;
    }

    @Override
    public String getHTML() {
        LinkedHashMap<String, String> ppr = org.lysis.reporters.html4r.tools.Format.getParProperties(this.parProp.getTextalign(), this.parProp.getPaddingbottom(), this.parProp.getPaddingtop(), this.parProp.getPaddingleft(), this.parProp.getPaddingright());
        String out = "<div>";
        String styleStr = org.lysis.reporters.html4r.tools.Format.getJSString(ppr);
        if (this.parIndex > 0) {
            int i = 1;
            while (i < this.parIndex + 1) {
                out = String.valueOf(out) + "<p style=\"" + styleStr + "\">" + this.parList.get(i).getHTML() + "</p>";
                ++i;
            }
        }
        out = String.valueOf(out) + "</div>";
        return out;
    }

    public CTTextBody getCTTextBody() throws Exception {
        CTTextParagraphProperties rpr = Format.getParProperties(this.parProp.getTextalign(), this.parProp.getPaddingbottom(), this.parProp.getPaddingtop(), this.parProp.getPaddingleft(), this.parProp.getPaddingright());
        Vector<CTTextParagraph> out = new Vector<CTTextParagraph>();
        if (this.parIndex > 0) {
            int i = 1;
            while (i < this.parIndex + 1) {
                CTTextParagraph temp = this.parList.get(i).getCTTextParagraph();
                temp.setPPr(rpr);
                out.add(temp);
                ++i;
            }
        }
        CTTextBody tb = new CTTextBody();
        CTTextBodyProperties pp = new CTTextBodyProperties();
        CTTextListStyle ls = new CTTextListStyle();
        tb.setBodyPr(pp);
        tb.setLstStyle(ls);
        tb.getP().addAll(out);
        return tb;
    }

    public Vector<P> getP() {
        PPr rpr = org.lysis.reporters.docx4r.tools.Format.getParProperties(this.parProp.getTextalign(), this.parProp.getPaddingbottom(), this.parProp.getPaddingtop(), this.parProp.getPaddingleft(), this.parProp.getPaddingright());
        Vector<P> out = new Vector<P>();
        if (this.parIndex > 0) {
            int i = 1;
            while (i < this.parIndex + 1) {
                P temp = this.parList.get(i).getP();
                temp.setPPr(rpr);
                out.add(temp);
                ++i;
            }
        }
        return out;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }
}

