% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeGenome.R
\name{makeGenome}
\alias{makeGenome}
\title{A helper function to create a gemome dataframe}
\usage{
makeGenome(DF, region = FALSE)
}
\arguments{
\item{DF}{A BED or ratio dataframe containing either 'score' or 'ratio' column (dataframe).}

\item{region}{String in the format 'chrI:1000-3000' (string, optional).}
}
\description{
makeGenome is called by plotGenome() and plotCoverage() functions if a genome dataframe is not
provided. It creates a BED-like dataframe containing unique chromosome names, their start coordinates
(assumed 0), their ends (highest value in the corresponding 'chromEnd' of the BED dataframe) and 'midY'
column containing half the max value of the "score" or "ratio" columns per chromosome. This later
serves as y coordinate to add chromosome names. Axis name is passed via comment to the output dataframe.
Extract it with 'attributes(genome)$axisName'.
}
\examples{
genomeDF <- makeGenome(W303_G2)
}
\keyword{bioinformatics}
\keyword{genomics}
\keyword{plotting}
