% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_sparseSCA.R
\name{cv_sparseSCA}
\alias{cv_sparseSCA}
\title{A K-fold cross-validation procedure when common/distinctive processes are unknown with Lasso and Group Lasso penalties.}
\usage{
cv_sparseSCA(DATA, Jk, R, MaxIter, NRSTARTS, LassoSequence, GLassoSequence,
  nfolds, method)
}
\arguments{
\item{DATA}{The concatenated data block, with rows representing subjects.}

\item{Jk}{A vector. Each element of this vector is the number of columns of a data block.}

\item{R}{The number of components (R>=2).}

\item{MaxIter}{Maximum number of iterations for this algorithm. The default value is 400.}

\item{NRSTARTS}{The number of multistarts for this algorithm. The default value is 1.}

\item{LassoSequence}{The range of Lasso tuning parameters. The default value is a sequence of 20 numbers from 0.00000001
to the smallest Lasso tuning parameter value that makes all the component loadings equal to zero. Note that by default the 20 numbers are equally spaced on the log scale. 
Furthermore, if \code{GLassoSequence} contains only one number, then by default \code{LassoSequence} is a sequence of 50 values.}

\item{GLassoSequence}{The range of Group Lasso tuning parameters. The default value is a sequence of 10 numbers from 0.00000001
to the smallest Group Lasso tuning parameter value that makes all the component loadings equal to zero. Note that by default the 10 numbers are equally spaced (but not on the log scale). 
Note that if \code{LassoSequence} contains only one number, then by default \code{GLassoSequence} is a sequence of 50 values.}

\item{nfolds}{Number of folds. If missing, then 10 fold cross-validation will be performed.}

\item{method}{"datablock" or "component". These are two options with respect to the grouping of the loadings as used in the Group Lasso penalty. 
If \code{method="component"}, the block-grouping of the coefficients is applied per component separately. If \code{method = "datablock"}, the grouping
is applied on the concatenated data block, with loadings of all components together. If \code{method} is missing, then the "component" method is used 
by default.}
}
\value{
\item{PRESS}{A matrix of predicted residual sum of squares (PRESS) for the sequences of Lasso and Group Lasso tuning parameters.}
\item{SE_MSE}{A matrix of standard errors for \code{PRESS}.}
\item{Press1SE}{The lowest PRESS + 1SE.}
\item{VarSelected}{A matrix of number of variables selected for the sequences of Lasso and Group Lasso tuning parameters.}
\item{Lasso_values}{The sequence of Lasso tuning parameters used for cross-validation. Users may also consult \code{Lambdaregion} (explained below).}
\item{Glasso_values}{The sequence of Group Lasso tuning parameters used for cross-validation. For example, suppose from the plot we found that the index number
for Group Lasso is \code{6}, its corresponding Group Lasso tuning parameter is \code{Glasso_values[6]}.}
\item{Lambdaregion}{A region of proper tuning parameter values for Lasso, given a certain value for Group Lasso. This means that, for example, if 5 Group Lasso tuning parameter values have been considered, \code{Lambdaregion} is a 5 by 2 matrix.}
\item{RecommendedLambda}{A pair (or sometimes a few pairs) of Lasso and Group Lasso tuning parameters that lead to a model with PRESS closest to the lowest PRESS + 1SE.}
\item{P_hat}{Estimated component loading matrix, given the recommended tuning parameters.}
\item{T_hat}{Estimated component score matrix, given the recommended tuning parameters.}
\item{plotlog}{An index number for function \code{plot}, which is not useful for users.}
}
\description{
\code{cv_sparseSCA} helps to find a range of Lasso and Group Lasso tuning parameters for the common component so as to generate sparse common component.
}
\details{
This function searches through a range of Lasso and Group Lasso tuning parameters for identifying common and distinctive components
}
\examples{
\dontrun{
DATA1 <- matrix(rnorm(50), nrow=5)
DATA2 <- matrix(rnorm(100), nrow=5)  
DATA <- cbind(DATA1, DATA2)
Jk <- c(10, 20) 
cv_sparseSCA(DATA, Jk, R=5, MaxIter = 100, NRSTARTS = 40, nfolds=10)
}
}
\references{
Witten, D.M., Tibshirani, R., & Hastie, T. (2009), A penalized matrix decomposition, with applications to sparse principal components and canonical correlation analysis. \emph{Biostatistics}, \emph{10}(3), 515-534.

Friedman, J., Hastie, T., & Tibshirani, R. (2010). A note on the group lasso and a sparse group lasso. arXiv preprint arXiv:1001.0736.

Yuan, M., & Lin, Y. (2006). Model selection and estimation in regression with grouped variables. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 68(1), 49-67.
}
