% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RedditExtractoR.R
\name{construct_graph}
\alias{construct_graph}
\title{Create a graph file from a single Reddit thread}
\usage{
construct_graph(content_data, plot = TRUE, write_to = NA)
}
\arguments{
\item{content_data}{A data frame produced by reddit_content command}

\item{plot}{A logical parameter indicating whether a graph is to be plotted or no (TRUE by default). Note that the root node corresponds to the thread itself rather than any of the comments.}

\item{write_to}{A character string specifying the path and file name where a graph object will be saved. The file must end with an extension such as *.gml. 
The following formats are allowed: edgelist, pajek, ncol,lgl, graphml, dimacs, gml, dot", leda.}
}
\value{
A graph object
}
\description{
Create a graph file from a single Reddit thread
}
\examples{
\dontrun{
my_url = "reddit.com/r/web_design/comments/2wjswo/design_last_reordering_the_web_design_process/"
url_data = reddit_content(my_url)
graph_object = construct_graph(url_data)
}

}

