/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.core.base.TypeResolver;
import org.drools.core.util.StringUtils;

public class AnnotationFactory {
    public static Annotation buildAnnotation(TypeResolver typeResolver, AnnotationDescr annotationDescr) {
        try {
            Class annotationClass = typeResolver.resolveType(annotationDescr.getFullyQualifiedName());
            return AnnotationFactory.buildAnnotation(annotationDescr, annotationClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Annotation buildAnnotation(AnnotationDescr annotationDescr, Class<?> annotationClass) {
        return (Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{Annotation.class, annotationClass}, (InvocationHandler)new AnnotationInvocationHandler(annotationClass, annotationDescr));
    }

    public static class AnnotationInvocationHandler
    implements InvocationHandler {
        private final Class<?> annotationClass;
        private final AnnotationDescr annotationDescr;

        public AnnotationInvocationHandler(Class<?> annotationClass, AnnotationDescr annotationDescr) {
            this.annotationClass = annotationClass;
            this.annotationDescr = annotationDescr;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("annotationType")) {
                return this.annotationClass;
            }
            if (method.getName().equals("toString")) {
                return this.toString();
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("equals")) {
                return this.annotationDescr.equals(args[0]);
            }
            try {
                this.annotationClass.getMethod(method.getName(), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Invoked not existing method " + method.getName() + " on annotation " + this.annotationClass.getName());
            }
            Object value = this.annotationDescr.getValue(method.getName());
            return value == null ? method.getDefaultValue() : this.normalizeResult(method.getReturnType(), value);
        }

        public int hashCode() {
            return this.annotationDescr.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof AnnotationInvocationHandler && this.annotationDescr.equals(((AnnotationInvocationHandler)obj).annotationDescr);
        }

        public String toString() {
            return this.annotationDescr.toString();
        }

        private Object normalizeResult(Class<?> resultClass, Object val) {
            String value = val.toString();
            if (resultClass == String.class) {
                if (this.annotationDescr.isStrict()) {
                    if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                        return value.substring(1, value.length() - 1);
                    }
                } else {
                    return value;
                }
            }
            if (resultClass == Boolean.class || resultClass == Boolean.TYPE) {
                return Boolean.valueOf(value);
            }
            if (resultClass == Integer.class || resultClass == Integer.TYPE) {
                return Integer.valueOf(value);
            }
            if (resultClass.isEnum()) {
                String annotationHead = resultClass.getSimpleName() + ".";
                int typePos = value.indexOf(annotationHead);
                if (typePos >= 0) {
                    value = value.substring(typePos + annotationHead.length());
                }
                try {
                    return Enum.valueOf(resultClass, value);
                }
                catch (IllegalArgumentException e) {
                    if (!this.annotationDescr.isStrict()) {
                        value = StringUtils.ucFirst((String)value);
                        try {
                            return Enum.valueOf(resultClass, value);
                        }
                        catch (IllegalArgumentException e2) {
                            return Enum.valueOf(resultClass, value.toUpperCase());
                        }
                    }
                    throw e;
                }
            }
            throw new RuntimeException("Cannot convert " + value + " to an instance of type " + resultClass.getName());
        }
    }
}

