% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F.nLL.R
\name{F.nLL}
\alias{F.nLL}
\title{Return the negative log likelihood for 
a set of distance values}
\usage{
F.nLL(a, dist, covars = NULL, like, w.lo = 0, w.hi = max(dist),
  series, expansions = 0, pointSurvey, for.optim = F)
}
\arguments{
\item{a}{A vector of parameter values for
the likelihood. Length of this vector must be 
  \code{expansions + 1 + 1*(like \%in\% c("hazrate", "uniform"))}.}

\item{dist}{A vector of observed distances. All values must be between 
\code{w.lo} and \code{w.hi} (see below).}

\item{covars}{Data frame containing values of covariates 
at each observation in \code{dist}.}

\item{like}{String specifying the form of the likelihood.
Built-in distance functions at present are "uniform", "halfnorm", 
"hazrate", "negexp", and "Gamma".  To be valid, a function 
named \code{paste(like,".like")} (e.g., "uniform.like") must exist
somewhere in this routine's scope.  This routine finds the ".like" 
function and calls it with the appropriate parameters.  
A user-defined likelihood can be implemented by simply defining a 
function with the ".like" extension and giving the root name here. 
For example, define a function named "myLike.like" in the 
\code{.GlobalEnv} and set \code{like="myLike"} here.  See 
the vignette on this topic.}

\item{w.lo}{Lower or left-truncation limit of the distances.
This is the minimum possible off-transect distance. Default is 0.}

\item{w.hi}{Upper or right-truncation limit of the distances. 
This is the maximum off-transect distance that could be observed. 
Default is the maximum observed distance.}

\item{series}{String specifying the type of expansion to 
use series if \code{expansions} > 0. Valid values at present 
are 'simple', 'hermite', and 'cosine'.}

\item{expansions}{A scalar specifying the number of terms 
in \code{series} to compute. Depending on the series, this 
could be 0 through 5. The default of 0 equates to no 
expansion terms of any type.}

\item{pointSurvey}{Boolean. TRUE if \code{dist} is point 
transect data, FALSE if line transect data.}

\item{for.optim}{Boolean. If TRUE, values are multiplied 
by 10^9 to help \code{optim} converge more consistently.}
}
\value{
A scalar, the negative of the log likelihood evaluated at 
parameters \code{a}, including expansion terms.
}
\description{
Return value of the negative log likelihood for 
a vector of observed distances given a specified likelihood, 
  number of expansion terms, and estimated parameters.
}
\seealso{
See \code{\link{uniform.like}} and links there; 
 \code{\link{dfuncEstim}}
}
\author{
Trent McDonald, WEST, Inc. \email{tmcdonald@west-inc.com}\cr
        Aidan McDonald, WEST, Inc. \email{aidan@mcdcentral.org}
}
\keyword{models}
