% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oos_LINEAR.R
\name{oos.linear}
\alias{oos.linear}
\title{Out-of-sample prediction for linear methods}
\usage{
oos.linear(Xnew, projection, trfinfo)
}
\arguments{
\item{Xnew}{an \eqn{(m\times p)} matrix or data frame whose rows are observations. If a vector is given,
it will be considered as an \eqn{(1\times p)} matrix with single observation.}

\item{projection}{a \eqn{(p\times ndim)} projection matrix.}

\item{trfinfo}{a list containing transformation information generated from manifold learning algorithms.
See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Ynew}{an \eqn{(m\times ndim)} matrix whose rows are embedded observations.}
}
}
\description{
Linear dimensionality reduction methods such as PCA, LPP, or ICA \emph{explicitly} returns a matrix
for mapping or projection. When we have new data, therefore, we can simply use the mapping provided.
Inputs \code{projection} and \code{trfinfo} should be brought from original model you trained.
}
\examples{
## generate sample data and separate them
X = aux.gensamples(n=500)
idxtest  = sample(1:500,50)
idxtrain = setdiff(1:500,idxtest)

Xtrain = X[idxtrain,]
Xtest  = X[idxtest,]

## run PCA for train data
res_train = do.pca(Xtrain,ndim=2,preprocess="whiten")

## perform OOS.LINEAR on new dataset
## note that inputs should be from a given model you trained
res_test  = oos.linear(Xtest, res_train$projection, res_train$trfinfo)

## let's compare
par(mfrow=c(1,2))
plot(res_train$Y[,1], res_train$Y[,2], main="original PCA")
plot(res_test$Ynew[,1], res_test$Ynew[,2], main="OOS results")

}
\author{
Kisung You
}
