% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_LISOMAP.R
\name{do.lisomap}
\alias{do.lisomap}
\title{Landmark Isometric Feature Mapping}
\usage{
do.lisomap(X, ndim = 2, ltype = "random", npoints = max(nrow(X)/5, ndim +
  1), preprocess = "center", type = c("proportion", 0.1),
  symmetric = "union", weight = TRUE)
}
\arguments{
\item{X}{an \code{(n-by-p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{ltype}{on how to select landmark points, either \code{"random"} or \code{"MaxMin"}.}

\item{npoints}{the number of landmark points to be drawn.}

\item{preprocess}{an option for preprocessing the data. This supports three methods,
``center'',``decorrelate'', or ``whiten''. See also \code{\link{aux.preprocess}}
for more details.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}. See also \code{\link{aux.graphnbd}} for more details.}

\item{weight}{\code{TRUE} to perform Landmark Isomap on weighted graph, or \code{FALSE} otherwise.}
}
\value{
a named list containing
\describe{
\item{Y}{an \code{(n-by-ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Landmark Isomap is a variant of Isomap in that
it first finds a low-dimensional embedding using a small portion of given dataset
and graft the others in a manner to preserve as much pairwise distance from
all the other data points to landmark points as possible.
}
\examples{
## generate data
## in order to pass CRAN pretest, n is set to be small.
X <- aux.gensamples(n=28)

## 1. use 10/28 data points with quarter-connected graph
output1 <- do.lisomap(X,ndim=2,type=c("proportion",0.25),npoints=10)

## 2. use 10/28 data points with half-connected graph
output2 <- do.lisomap(X,ndim=2,type=c("proportion",0.50),npoints=10)

## 3. use 14/28 data points with half-connected graph
output3 <- do.lisomap(X,ndim=2,type=c("proportion",0.50),npoints=14)

## Visualize three different projections
par(mfrow=c(1,3))
plot(output1$Y[,1],output1$Y[,2],main="5\%")
plot(output2$Y[,1],output2$Y[,2],main="10\%")
plot(output3$Y[,1],output3$Y[,2],main="50\%")



}
\references{
\insertRef{silva_global_2003}{Rdimtools}
}
\seealso{
\code{\link{do.isomap}}
}
\author{
Kisung You
}
