% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rdca_package.R
\name{decline_fit_param}
\alias{decline_fit_param}
\title{Arps decline_fit object}
\usage{
decline_fit_param(
  input_unit = "Field",
  output_unit = "Field",
  fluid = "oil",
  model = "exponential",
  fit_data = "rate",
  prod_data,
  initial_param,
  lower = NULL,
  upper = NULL,
  control = NULL
)
}
\arguments{
\item{input_unit}{a unit system for parameters, a character string either 'SI' or 'Field'}

\item{output_unit}{a unit system for properties, a character string either 'SI' or 'Field'}

\item{fluid}{fluid type, a character string either 'oil' or 'gas'}

\item{model}{decline model, a character string. 'exponential', 'harmonic', 'hyperbolic', and 'modified_hyperbolic' models are currently available}

\item{fit_data}{a character string, either 'rate', or 'cum'}

\item{prod_data}{a numeric vector of rates or cumulative according to 'fit_data'}

\item{initial_param}{a numeric vector of initial estimates for the Arps decline model}

\item{lower}{an optional numeric vector of lower bounds for the Arps decline model parameters. See 'minpack.lm' package for details}

\item{upper}{an optional numeric vector of upper bounds for the Arps decline model parameters. See 'minpack.lm' package for details}

\item{control}{an optional list of control settings. See 'minpack.lm' package for details}
}
\value{
a list of class 'decline_fit' with all the required parameters for the decline_fit() S3 methods
}
\description{
Create an object of class 'decline_fit'
}
\examples{

prod_data <- 3000 * exp(-0.00234 * c(1:300))
dcl_fit_param_exp <- decline_fit_param(input_unit = "Field", output_unit = "Field",
fluid = "oil", model = "exponential", fit_data = "rate", prod_data = prod_data,
initial_param = c(1000, 0.1, 0), lower = NULL, upper = NULL, control = NULL)

dcl_fit_param_exp

prod_data <- 4500 / (1 + 0.002 * 0.834 * c(1:400)) ^ (1 / 0.834)
dcl_fit_param_mod_hyp <- decline_fit_param(input_unit = "Field", output_unit = "Field",
fluid = "oil", model = "modified_hyperbolic", fit_data = "rate", prod_data = prod_data,
initial_param = c(10000, 0.1, 0.8, 0.01), lower = NULL,upper = NULL,
control = list(maxiter = 100))

dcl_fit_param_mod_hyp
}
