% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-Rd.R
\name{testing-Rd}
\alias{testing-Rd}
\alias{is_Rd_string}
\alias{are_Rd_strings}
\alias{is_Rd_tag}
\alias{are_Rd_tags}
\alias{is_Rd}
\alias{is_valid_Rd_list}
\alias{is_valid_Rd_object}
\title{Testing Rd types

These provide methods for testing if an object is valid.}
\usage{
is_Rd_string(x, tags = NULL, strict = FALSE, reason = TRUE)

are_Rd_strings(x, tags = NULL, strict = FALSE)

is_Rd_tag(x, tags = NULL, strict = FALSE, reason = TRUE)

are_Rd_tags(x, tags = NULL, strict = FALSE)

is_Rd(x, strict = FALSE)

is_valid_Rd_list(x, tags = NULL, strict = FALSE,
  deep = !isTRUE(strict) || !missing(tags))

is_valid_Rd_object(x, tags = NULL, strict = FALSE,
  deep = !isTRUE(strict) || !missing(tags))
}
\arguments{
\item{x}{object to test}

\item{tags}{the type of tag(s) allowed in the \code{Rd_tag} attribute.}

\item{strict}{if the class must be set. A value of NA indicates that the
first level need not be classed but all subsequent must be.}

\item{reason}{should the reason for failure be included.
Used in \code{\link[assertthat:assert_that]{assertthat::assert_that()}} and related functions.}

\item{deep}{should contained elements also be checked for validity?}
}
\description{
Testing Rd types

These provide methods for testing if an object is valid.
}
\section{Functions}{
\itemize{
\item \code{is_Rd_string}: test if object is a valid Rd string type.

\item \code{are_Rd_strings}: Vector version of is_Rd_string.

\item \code{is_Rd_tag}: Check if a list is a valid \code{Rd_tag} object.

\item \code{are_Rd_tags}: Vector version of is_Rd_tag

\item \code{is_Rd}: check if a list is an Rd container object.

\item \code{is_valid_Rd_list}: Check that an object is a valid Rd list,
an \code{Rd_tag} or \code{Rd}, but not an \code{Rd_string}

\item \code{is_valid_Rd_object}: Check that an object is valid
}}

\examples{
is_Rd_string('nope')
is_Rd_string(structure('Valid but not strict', Rd_tag='TEXT'))
is_Rd_string(structure('Valid but not strict', Rd_tag='TEXT'), strict=TRUE)
is_Rd_string(Rd_text('Valid and strict'), strict=TRUE)
are_Rd_strings(Rd( Rd_alias('example'), '\\n'
                 , Rd_name('example'), '\\n'
                 ))
is_Rd_tag(Rd('text'))
is_Rd_tag(Rd_alias('alias'))
are_Rd_tags(Rd( Rd_alias('example'), '\\n'
              , Rd_name('example'), '\\n'
              ))
is_Rd(list())
is_Rd(list(), strict=TRUE)
is_Rd(Rd(), strict=TRUE)
is_valid_Rd_list(Rd_name('name'))
is_valid_Rd_list(Rd('text'))
is_valid_Rd_list(Rd_text('text'))
is_valid_Rd_object(Rd_name('name'))
is_valid_Rd_object(Rd('text'))
is_valid_Rd_object(Rd_text('text'))
}
