% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construction.R
\name{Rd_string_creation}
\alias{Rd_string_creation}
\alias{Rd_string}
\alias{Rd_text}
\alias{Rd_rcode}
\alias{Rd_verb}
\alias{Rd_symb}
\alias{Rd_comment}
\title{Rd String Construction}
\usage{
Rd_string(content, type = c("TEXT", "RCODE", "VERB", "COMMENT",
  "UNKNOWN", "LIST"))

Rd_text(content)

Rd_rcode(content)

Rd_verb(content)

Rd_symb(content)

Rd_comment(content)
}
\arguments{
\item{content}{a string to type as an Rd string type}

\item{type}{the type of text is is.}
}
\description{
Construct a Rd string type.
}
\section{Functions}{
\itemize{
\item \code{Rd_text}: Type as plain text.

\item \code{Rd_rcode}: Type as R Code.

\item \code{Rd_verb}: Type as R symbol or 'verb'.

\item \code{Rd_symb}: Type as R symbol or 'verb'.

\item \code{Rd_comment}: type as Rd comment. Comments must start with the comment character '%'.
}}

\examples{
## Plain text
Rd_text("Plain text")
## R Code
Rd_rcode("code()")
## Symbols, i.e. verbs
Rd_verb("verb")
Rd_symb("symbol")
## Rd Comments
Rd_comment("\% Rd/LaTeX comment")
}
\seealso{
Other construction: \code{\link{Rd_tag}}, \code{\link{Rd}}
}
\concept{construction}
