% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSGD.R
\name{SharkBSGDTrain}
\alias{SharkBSGDTrain}
\title{Budgeted SGD Train.}
\usage{
SharkBSGDTrain(x, y = NULL, verbose = FALSE, budget = 500,
  strategy = "Merge", C = 1, gamma = 1, epochs = 1)
}
\arguments{
\item{x}{matrix with input data}

\item{y}{vector with labels}

\item{verbose}{verbose output?}

\item{budget}{size of budget}

\item{strategy}{strategy to use to maintain the budget size. 
choises are 'Merge', 'RemoveSmallest', 'RemoveRandom, 'Project'}

\item{C}{regularization constant}

\item{gamma}{kernel bandwidth for RBF kernel}

\item{epochs}{number of iterations through data set}
}
\description{
This will train a support vector machine by an SGD (Pegasos-like).
It will limit the number of support vector machines by applying the given
budget maintenance strategy.
See more on http://image.diku.dk/shark/sphinx_pages/build/html/rest_sources/tutorials/algorithms/kernelBudgetedSGD.html
}
\note{
Currently works only for binary classification. Uses only RBF kernel.
}
