% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cqp.R
\name{cqp_initialize}
\alias{cqp_initialize}
\alias{cqp_is_initialized}
\alias{cqp_get_registry}
\alias{cqp_reset_registry}
\title{Initialize Corpus Query Processor (CQP).}
\usage{
cqp_initialize(registry = Sys.getenv("CORPUS_REGISTRY"))

cqp_is_initialized()

cqp_get_registry()

cqp_reset_registry(registry = Sys.getenv("CORPUS_REGISTRY"))
}
\arguments{
\item{registry}{the registry directory}
}
\description{
CQP needs to know where to look for CWB indexed corpora. To initialize CQP,
call \code{cqp_initialize}. To reset the registry, use the function
\code{cqp_reset_registry}. To get the registry used by CQP, use
\code{cqp_get_registry}. To get the initialization status, use
\code{cqp_is_initialized}
}
\examples{
cqp_is_initialized() # check initialization status
if (!cqp_is_initialized()) cqp_initialize()
cqp_is_initialized() # check initialization status (TRUE now?)
cqp_get_registry() # get registry dir used by CQP
regdir <- system.file(package = "RcppCWB", "extdata", "cwb", "registry")
if (cqp_get_registry() != regdir) cqp_reset_registry(registry = regdir)
cqp_list_corpora() # get list of corpora
}
\author{
Andreas Blaette, Bernard Desgraupes, Sylvain Loiseau
}
