% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode.R
\name{encode}
\alias{encode}
\alias{p_attribute_encode}
\alias{p_attribute_makeall}
\alias{p_attribute_huffcode}
\alias{p_attribute_compress_rdx}
\alias{s_attribute_encode}
\title{Encode CWB Corpus.}
\usage{
p_attribute_encode(token_stream, p_attribute = "word", data_dir)

p_attribute_makeall(token_stream, p_attribute = "word", data_dir)

p_attribute_huffcode(corpus, p_attribute,
  registry_dir = Sys.getenv("CORPUS_REGISTRY"))

p_attribute_compress_rdx(corpus, p_attribute,
  registry_dir = Sys.getenv("CORPUS_REGISTRY"))

s_attribute_encode(values, data_dir, s_attribute, region_matrix)
}
\arguments{
\item{token_stream}{a character vector with the tokens of the corpus}

\item{p_attribute}{the positional attribute}

\item{data_dir}{the data directory for the corpus with the binary files}

\item{corpus}{the CWB corpus (needed by \code{p_attribute_huffcode} and \code{p_attribute_compress_rdx})}

\item{registry_dir}{registry directory (needed by \code{p_attribute_huffcode} and \code{p_attribute_compress_rdx})}

\item{values}{values for structural annotations}

\item{s_attribute}{the structural attribute}

\item{region_matrix}{a matrix with left and right corpus positions (regions) of structural annotations}
}
\description{
Create indexed and compressed positional attribute from a character vector of
tokens (the token stream), and structural annotations.
}
\details{
Four steps generate the binary CWB corpus data format for positional
attributes: First, encode a character vector (the token stream) using
\code{p_attribute_encode}. Second, create reverse index using
\code{p_attribute_makeall}. Third, compress token stream using
\code{p_attribute_huffcode}. Fourth, compress index files using
\code{p_attribute_compress_rdx}.

The implementation for the first two steps (\code{p_attribute_encode} and
\code{p_attribute_makeall}) is a pure R implementation (so far). These two
steps are enough to use the CQP functionality.

To run \code{p_attribute_huffcode} and \code{p_attribute_compress_rdx}, an
installation of the CWB is required.

See the CQP Corpus Encoding Tutorial
(\url{http://cwb.sourceforge.net/files/CWB_Encoding_Tutorial.pdf}) for an
explanation of the procedure (section 3, ``Indexing and compression without
CWB/Perl'').
}
\examples{
tokens <- readLines(system.file(package = "RcppCWB", "extdata", "examples", "reuters.txt"))

tmpdir <- tempdir()
if (.Platform$OS.type == "windows") tmpdir <- normalizePath(tmpdir, winslash = "/")
registry_tmp <- file.path(tmpdir, "registry")
data_dir_tmp <- file.path(tmpdir, "data_dir")
dir.create (registry_tmp)
dir.create(data_dir_tmp)

p_attribute_encode(
  token_stream = tokens, p_attribute = "word",
  data_dir = data_dir_tmp
  )
p_attribute_makeall(
  token_stream = tokens, p_attribute = "word",
  data_dir = data_dir_tmp
)

regfile <- registry_file_write(
  registry_dir = registry_tmp, corpus = "REUTERS", data_dir = data_dir_tmp,
  corpus_properties = c(encoding = "utf-8", language = "en"), p_attributes = "word"
  )
if (cqp_is_initialized()) cqp_reset_registry(registry_tmp) else cqp_initialize(registry_tmp)

cqp_query(corpus = "REUTERS", query = '[]{3} "oil" []{3};')
regions <- cqp_dump_subcorpus(corpus = "REUTERS")
kwic <- apply(regions, 1, function(region){
  ids <- cl_cpos2id("REUTERS", "word", registry_tmp, cpos = region[1]:region[2])
  words <- cl_id2str(corpus = "REUTERS", p_attribute = "word", registry = registry_tmp, id = ids)
  paste0(words, collapse = " ")
})
kwic[1:10]
}
