% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpm_methods.R
\name{mpm_methods}
\alias{mpm_methods}
\alias{mpm_has_prop}
\alias{mpm_has_prop,CompadreMat-method}
\alias{mpm_has_prop,CompadreDB-method}
\alias{mpm_has_active}
\alias{mpm_has_active,CompadreMat-method}
\alias{mpm_has_active,CompadreDB-method}
\alias{mpm_has_dorm}
\alias{mpm_has_dorm,CompadreMat-method}
\alias{mpm_has_dorm,CompadreDB-method}
\alias{mpm_first_active}
\alias{mpm_first_active,CompadreMat-method}
\alias{mpm_first_active,CompadreDB-method}
\title{Extract stage-class information from CompadreMat or CompadreDB objects}
\usage{
mpm_has_prop(object)

\S4method{mpm_has_prop}{CompadreMat}(object)

\S4method{mpm_has_prop}{CompadreDB}(object)

mpm_has_active(object)

\S4method{mpm_has_active}{CompadreMat}(object)

\S4method{mpm_has_active}{CompadreDB}(object)

mpm_has_dorm(object)

\S4method{mpm_has_dorm}{CompadreMat}(object)

\S4method{mpm_has_dorm}{CompadreDB}(object)

mpm_first_active(object)

\S4method{mpm_first_active}{CompadreMat}(object)

\S4method{mpm_first_active}{CompadreDB}(object)
}
\arguments{
\item{object}{A CompadreMat or CompadreDB object}
}
\value{
No return value, called for side effects
}
\description{
Methods for extracting stage-class information from CompadreMat or CompadreDB
objects, including whether the matrix population model includes one or more
propagule stages (\code{mpm_has_prop}), dormant stages (\code{mpm_has_dorm}),
or active stages (\code{mpm_has_active}), and the integer index of the first
active stage class (\code{mpm_first_active}).

These methods will return a single value if passed a CompadreMat object, or a
vector of values if passed a CompadreDB object (one value for every
CompadreMat object within the column 'mat').
}
\examples{
# with CompadreMat object
mpm_has_prop(Compadre$mat[[1]])
mpm_has_active(Compadre$mat[[1]])
mpm_has_dorm(Compadre$mat[[1]])
mpm_first_active(Compadre$mat[[1]])

# with CompadreDB object
mpm_has_prop(Compadre)
mpm_has_active(Compadre)
mpm_has_dorm(Compadre)
mpm_first_active(Compadre)

}
\seealso{
Other data checking: 
\code{\link{cdb_check_species}()},
\code{\link{cdb_collapse}()},
\code{\link{cdb_compare}()},
\code{\link{cdb_flag}()}
}
\author{
Patrick Barks <patrick.barks@gmail.com>
}
\concept{data checking}
